% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_methods.r
\name{modify_metadata}
\alias{modify_metadata}
\alias{mutate.rbiom}
\alias{rename.rbiom}
\title{Create, modify, and delete metadata fields.}
\usage{
\method{mutate}{rbiom}(.data, ..., clone = TRUE)

\method{rename}{rbiom}(.data, ..., clone = TRUE)
}
\arguments{
\item{.data}{An \link[=rbiom_objects]{rbiom object}, such as from \code{\link[=as_rbiom]{as_rbiom()}}.}

\item{...}{Passed on to \code{\link[dplyr:mutate]{dplyr::mutate()}} or \code{\link[dplyr:rename]{dplyr::rename()}}.}

\item{clone}{Create a copy of \code{biom} before modifying. If \code{FALSE}, \code{biom}
is modified in place as a side-effect. See \link[=speed]{speed ups} for
use cases. Default: \code{TRUE}}
}
\value{
An \link[=rbiom_objects]{rbiom object}.
}
\description{
mutate() creates new fields in \verb{$metadata} that are functions of existing
metadata fields. It can also modify (if the name is the same as an existing
field) and delete fields (by setting their value to NULL).
}
\examples{
    library(rbiom) 
    
    biom <- slice_max(hmp50, BMI, n = 6)
    biom$metadata
    
    # Add a new field to the metadata
    biom <- mutate(biom, Obsese = BMI >= 30)
    biom$metadata
    
    # Rename a metadata field
    biom <- rename(biom, 'Age (years)' = "Age")
    biom$metadata

}
\seealso{
Other transformations: 
\code{\link{rarefy}()},
\code{\link{rarefy_cols}()},
\code{\link{slice_metadata}},
\code{\link{subset}()},
\code{\link{with}()}
}
\concept{transformations}
