% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layer_lines.R
\name{ly_contour}
\alias{ly_contour}
\title{Add a "contour" layer to a Bokeh figure}
\usage{
ly_contour(fig, z, x = seq(0, 1, length.out = nrow(z)), y = seq(0, 1,
  length.out = ncol(z)), nlevels = 10, levels = pretty(range(z, na.rm =
  TRUE), nlevels), color = "black", alpha = 1, width = 1, type = 1,
  lname = NULL, lgroup = NULL, visible = TRUE, ...)
}
\arguments{
\item{fig}{figure to modify}

\item{z}{a matrix containing the values to compute contour lines for}

\item{x, y}{locations of grid lines at which the values in \code{image} are measured (see \code{\link[grDevices]{contourLines}})}

\item{nlevels, levels}{parameters sent to \code{\link[grDevices]{contourLines}})}

\item{color}{color to use to stroke lines with - a hex code (with no alpha) or any of the 147 named CSS colors, e.g 'green', 'indigo'}

\item{alpha}{transparency value for the line between 0 (transparent) and 1 (opaque)}

\item{width}{stroke width in units of pixels}

\item{type}{an integer between 1 and 6 matching the \code{lty} property in \code{\link[graphics]{par}} or an array of integer pixel distances that describe the on-off pattern of dashing to use}

\item{lname}{layer name}

\item{lgroup}{layer group}

\item{visible}{should the layer be visible?}

\item{\ldots}{additional parameters for fine control over line properties (see "Additional parameters" below)}
}
\description{
Computes and draws contour lines.
}
\section{Additional parameters}{

\tabular{ll}{
  \code{line_join} \tab how path segments should be joined together 'miter' 'round' 'bevel' \cr
  \code{line_cap} \tab how path segments should be terminated 'butt' 'round' 'square' \cr
  \code{line_dash} \tab an integer between 1 and 6 matching the \code{lty} property in \code{\link[graphics]{par}} or an array of integer pixel distances that describe the on-off pattern of dashing to use \cr
  \code{line_dash_offset} \tab the distance in pixels into the line_dash that the pattern should start from
 }
}
\examples{
\donttest{
p <- figure(xlim = c(0, 1), ylim = c(0, 1), title = "Volcano") \%>\%
  ly_image(volcano) \%>\%
  ly_contour(volcano)
p
}
}
\seealso{
Other layer functions: \code{\link{ly_abline}},
  \code{\link{ly_annular_wedge}}, \code{\link{ly_annulus}},
  \code{\link{ly_arc}}, \code{\link{ly_bar}},
  \code{\link{ly_bezier}}, \code{\link{ly_boxplot}},
  \code{\link{ly_crect}}, \code{\link{ly_curve}},
  \code{\link{ly_density}}, \code{\link{ly_hist}},
  \code{\link{ly_image_url}}, \code{\link{ly_image}},
  \code{\link{ly_lines}}, \code{\link{ly_map}},
  \code{\link{ly_multi_line}}, \code{\link{ly_oval}},
  \code{\link{ly_patch}}, \code{\link{ly_points}},
  \code{\link{ly_polygons}}, \code{\link{ly_quadratic}},
  \code{\link{ly_quantile}}, \code{\link{ly_ray}},
  \code{\link{ly_rect}}, \code{\link{ly_segments}},
  \code{\link{ly_text}}, \code{\link{ly_wedge}}
}

