% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rbwPanel.R
\name{rbwPanel}
\alias{rbwPanel}
\title{Residual Balancing Weights for Analyzing Time-varying Treatments}
\usage{
rbwPanel(
  treatment,
  xmodels,
  id,
  time,
  data,
  base_weights,
  future = 1L,
  max_iter = 200,
  print_level = 1,
  tol = 1e-06
)
}
\arguments{
\item{treatment}{A symbol or character string for the treatment/treatment variable.}

\item{xmodels}{A list of fitted \code{lm} or \code{glm} objects for
time-varying confounders.}

\item{id}{A symbol or character string for the unit id variable.}

\item{time}{A symbol or character string for the time variable. The time variable should be numeric.}

\item{data}{A data frame containing all variables in the model.}

\item{base_weights}{(Optional) A vector of base weights (or its name).}

\item{future}{An integer indicating the number of future treatments in the balancing conditions. When
\code{future > 0}, the residualized time-varying covariates are balanced not only with respect to
current treatment \eqn{D_t}, but also with respect to future treatments \eqn{D_{t+1},\ldots D_{t + future}}.}

\item{max_iter}{Maximum number of iterations for Newton's method.}

\item{print_level}{The level of printing: \describe{
\item{1}{normal: print whether the algorithm converges or not}
\item{2}{detailed: print also the maximum absolute value of the deviation between the moments
 of the reweighted data and the target moments in each iteration}
\item{3}{very detailed: print also the step length of the line searcher in iterations where
 a full Newton step is excessive.}
}}

\item{tol}{Tolerance parameter used to determine convergence.}
}
\value{
A list containing the results.
 \item{weights}{A data frame containing id and residual balancing weights.}
 \item{constraints}{A matrix of (linearly independent) residual balancing constraints}
 \item{eb_out}{Results from calling \code{\link{eb2}} function}
 \item{call}{The matched call.}
}
\description{
\code{rbwPanel} is a function that produces residual balancing weights (rbw) for
estimating the marginal effects of time-varying treatments. The user supplies
a long format data frame (each row being a unit-period) and a list of
fitted model objects for time-varying confounders. The residuals of each time-varying
covariate \eqn{X_t} are balanced across both current treatment \eqn{D_t} and
the regressors of \eqn{X_t}. In addition, when \code{future > 0},
the residuals are also balanced across future treatments \eqn{D_{t+1},\ldots D_{t + future}}.
}
\examples{
# models for time-varying confounders
m1 <- lm(dem.polls ~ (d.gone.neg.l1 + dem.polls.l1 + undother.l1) * factor(week),
data = campaign_long)
m2 <- lm(undother ~ (d.gone.neg.l1 + dem.polls.l1 + undother.l1) * factor(week),
data = campaign_long)

xmodels <- list(m1, m2)

# residual balancing weights
rbwPanel_fit <- rbwPanel(treatment = d.gone.neg, xmodels = xmodels, id = id,
time = week, data = campaign_long)

summary(rbwPanel_fit$weights)

# merge weights into wide-format data
campaign_wide2 <- merge(campaign_wide, rbwPanel_fit$weights, by = "id")

# fit a marginal structural model (adjusting for baseline confounders)
if(require(survey)){
  rbw_design <- svydesign(ids = ~ 1, weights = ~ rbw, data = campaign_wide2)
  msm_rbwPanel <- svyglm(demprcnt ~ cum_neg * deminc + camp.length + factor(year) + office,
  design = rbw_design)
  summary(msm_rbwPanel)
}
}
