% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biSquare.R
\name{bisquare}
\alias{bisquare}
\title{Bisquare Basis Functions}
\usage{
bisquare(crd, knots, w = NULL, ..., longlat = TRUE)
}
\arguments{
\item{crd}{A matrix object. The (x,y) coordinates of the reference
points \{nCrd x 2\}.}

\item{knots}{A matrix object. The (x,y) coordinates of the knots \{r x 2\}.}

\item{w}{A numeric object. The positive scaling factor (bandwidth).}

\item{...}{ignored. Included only to require naming of inputs that follow.}

\item{longlat}{A logical object. If FALSE, Euclidean
distance is calculated; if TRUE, Great Circle distance is calculated.
See ?sp::spDists for more information.}
}
\value{
A matrix of bisquare functions evaluated at all combinations of
 crd and knots \{ nCrd x r \}.
}
\description{
Provides an implementation of the bisquare basis functions defined as
\deqn{ \Psi_{j}(s) =
 \{ 1 - (||s - c_j||/w)^2\}^2 \mathrm{I}( ||s-c_j|| \leq w ).}
}
\details{
Distances between reference coordinates and knots are obtained using 
  sp::spDists().
}
\examples{

  data(countyExample)

  bisquare(crd = sp::coordinates(county), knots = knots)

}
\references{
Cressie, N. and Johannesson, G. (2008). Fixed rank kriging for
very large spatial data sets. Journal of the Royal Statistical Society, 
Series B, 70, 209--226. <doi:10.1111/j.1467-9868.2007.00633.x>.
}
