% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mask_sunlit_canopy.R
\name{mask_sunlit_canopy}
\alias{mask_sunlit_canopy}
\title{Mask sunlit canopy}
\usage{
mask_sunlit_canopy(caim, m = NULL)
}
\arguments{
\item{caim}{\linkS4class{SpatRaster}. The return of a call to
\code{\link{read_caim}}.}

\item{m}{\linkS4class{SpatRaster}. A mask. For hemispherical photographs,
check \code{\link{mask_hs}}. Default (\code{NULL}) is the equivalent to
enter \code{!is.na(caim$Red)}. See the Details section in
\code{\link{local_fuzzy_thresholding}} to understand how this argument can
modify the output.}
}
\value{
An object of class \linkS4class{SpatRaster} with values \code{0} and
  \code{1}.
}
\description{
It is a wrapper function around \code{\link{membership_to_color}}. It
masks pixels that are likely sunlit canopy.
}
\examples{
\dontrun{
caim <- read_caim() \%>\% normalize()
z <- zenith_image(ncol(caim), lens("Nikon_FCE9"))
m <- !is.na(z)
sunlit_canopy <- mask_sunlit_canopy(caim, m)
plot(sunlit_canopy)
}
}
\seealso{
Other Segmentation Functions: 
\code{\link{chessboard}()},
\code{\link{mask_hs}()},
\code{\link{polar_qtree}()},
\code{\link{qtree}()},
\code{\link{rings_segmentation}()},
\code{\link{sectors_segmentation}()},
\code{\link{sky_grid_segmentation}()}
}
\concept{Segmentation Functions}
