/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.style;

import com.lowagie.text.Font;
import com.lowagie.text.rtf.RtfExtendedElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.style.RtfColor;
import com.lowagie.text.rtf.style.RtfFontList;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class RtfFont
extends Font
implements RtfExtendedElement {
    private static final byte[] FONT_FAMILY = "\\froman".getBytes();
    private static final byte[] FONT_CHARSET = "\\fcharset".getBytes();
    public static final byte[] FONT_SIZE = "\\fs".getBytes();
    private static final byte[] FONT_BOLD = "\\b".getBytes();
    private static final byte[] FONT_ITALIC = "\\i".getBytes();
    private static final byte[] FONT_UNDERLINE = "\\ul".getBytes();
    private static final byte[] FONT_STRIKETHROUGH = "\\strike".getBytes();
    private static final byte[] FONT_DOUBLE_STRIKETHROUGH = "\\striked".getBytes();
    private static final byte[] FONT_SHADOW = "\\shad".getBytes();
    private static final byte[] FONT_OUTLINE = "\\outl".getBytes();
    private static final byte[] FONT_EMBOSSED = "\\embo".getBytes();
    private static final byte[] FONT_ENGRAVED = "\\impr".getBytes();
    private static final byte[] FONT_HIDDEN = "\\v".getBytes();
    public static final int STYLE_NONE = 0;
    public static final int STYLE_BOLD = 1;
    public static final int STYLE_ITALIC = 2;
    public static final int STYLE_UNDERLINE = 4;
    public static final int STYLE_STRIKETHROUGH = 8;
    public static final int STYLE_DOUBLE_STRIKETHROUGH = 16;
    public static final int STYLE_SHADOW = 32;
    public static final int STYLE_OUTLINE = 64;
    public static final int STYLE_EMBOSSED = 128;
    public static final int STYLE_ENGRAVED = 256;
    public static final int STYLE_HIDDEN = 512;
    private String fontName = "Times New Roman";
    private int fontSize = 10;
    private int fontStyle = 0;
    private int fontNumber = 0;
    private RtfColor color = null;
    private int charset = 0;
    protected RtfDocument document = null;

    public RtfFont(String fontName) {
        super(-1, -1.0f, -1, null);
        this.fontName = fontName;
    }

    public RtfFont(String fontName, float size) {
        super(-1, size, -1, null);
        this.fontName = fontName;
    }

    public RtfFont(String fontName, float size, int style) {
        super(-1, size, style, null);
        this.fontName = fontName;
    }

    public RtfFont(String fontName, float size, int style, Color color) {
        super(-1, size, style, color);
        this.fontName = fontName;
    }

    protected RtfFont(RtfDocument doc, int fontNumber) {
        this.document = doc;
        this.fontNumber = fontNumber;
        this.color = new RtfColor(doc, 0, 0, 0);
    }

    public RtfFont(RtfDocument doc, Font font) {
        this.document = doc;
        if (font != null) {
            if (font instanceof RtfFont) {
                this.fontName = ((RtfFont)font).getFontName();
            } else {
                this.setToDefaultFamily(font.getFamilyname());
            }
            if (font.getBaseFont() != null) {
                String[][] fontNames = font.getBaseFont().getFullFontName();
                int i = 0;
                while (i < fontNames.length) {
                    if (fontNames[i][2].equals("0")) {
                        this.fontName = fontNames[i][3];
                        break;
                    }
                    if (fontNames[i][2].equals("1033") || fontNames[i][2].equals("")) {
                        this.fontName = fontNames[i][3];
                    }
                    ++i;
                }
            }
            this.setSize(font.size());
            this.setStyle(font.style());
            this.setColor(font.color());
        }
        if (this.fontName.equalsIgnoreCase("unknown")) {
            return;
        }
        if (this.document != null) {
            this.setRtfDocument(this.document);
        }
    }

    public byte[] writeDefinition() {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            result.write(FONT_FAMILY);
            result.write(FONT_CHARSET);
            result.write(this.intToByteArray(this.charset));
            result.write(DELIMITER);
            result.write(this.document.filterSpecialChar(this.fontName, true, false).getBytes());
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return result.toByteArray();
    }

    public byte[] writeBegin() {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            if (this.fontNumber != -1) {
                result.write(RtfFontList.FONT_NUMBER);
                result.write(this.intToByteArray(this.fontNumber));
            }
            if (this.fontSize != -1) {
                result.write(FONT_SIZE);
                result.write(this.intToByteArray(this.fontSize * 2));
            }
            if (this.fontStyle != -1) {
                if ((this.fontStyle & 1) == 1) {
                    result.write(FONT_BOLD);
                }
                if ((this.fontStyle & 2) == 2) {
                    result.write(FONT_ITALIC);
                }
                if ((this.fontStyle & 4) == 4) {
                    result.write(FONT_UNDERLINE);
                }
                if ((this.fontStyle & 8) == 8) {
                    result.write(FONT_STRIKETHROUGH);
                }
                if ((this.fontStyle & 0x200) == 512) {
                    result.write(FONT_HIDDEN);
                }
                if ((this.fontStyle & 0x10) == 16) {
                    result.write(FONT_DOUBLE_STRIKETHROUGH);
                    result.write(this.intToByteArray(1));
                }
                if ((this.fontStyle & 0x20) == 32) {
                    result.write(FONT_SHADOW);
                }
                if ((this.fontStyle & 0x40) == 64) {
                    result.write(FONT_OUTLINE);
                }
                if ((this.fontStyle & 0x80) == 128) {
                    result.write(FONT_EMBOSSED);
                }
                if ((this.fontStyle & 0x100) == 256) {
                    result.write(FONT_ENGRAVED);
                }
            }
            if (this.color != null) {
                result.write(this.color.writeBegin());
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return result.toByteArray();
    }

    public byte[] writeEnd() {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            if (this.fontStyle != -1) {
                if ((this.fontStyle & 1) == 1) {
                    result.write(FONT_BOLD);
                    result.write(this.intToByteArray(0));
                }
                if ((this.fontStyle & 2) == 2) {
                    result.write(FONT_ITALIC);
                    result.write(this.intToByteArray(0));
                }
                if ((this.fontStyle & 4) == 4) {
                    result.write(FONT_UNDERLINE);
                    result.write(this.intToByteArray(0));
                }
                if ((this.fontStyle & 8) == 8) {
                    result.write(FONT_STRIKETHROUGH);
                    result.write(this.intToByteArray(0));
                }
                if ((this.fontStyle & 0x200) == 512) {
                    result.write(FONT_HIDDEN);
                    result.write(this.intToByteArray(0));
                }
                if ((this.fontStyle & 0x10) == 16) {
                    result.write(FONT_DOUBLE_STRIKETHROUGH);
                    result.write(this.intToByteArray(0));
                }
                if ((this.fontStyle & 0x20) == 32) {
                    result.write(FONT_SHADOW);
                    result.write(this.intToByteArray(0));
                }
                if ((this.fontStyle & 0x40) == 64) {
                    result.write(FONT_OUTLINE);
                    result.write(this.intToByteArray(0));
                }
                if ((this.fontStyle & 0x80) == 128) {
                    result.write(FONT_EMBOSSED);
                    result.write(this.intToByteArray(0));
                }
                if ((this.fontStyle & 0x100) == 256) {
                    result.write(FONT_ENGRAVED);
                    result.write(this.intToByteArray(0));
                }
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return result.toByteArray();
    }

    public byte[] write() {
        return new byte[0];
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RtfFont)) {
            return false;
        }
        RtfFont font = (RtfFont)obj;
        boolean result = true;
        return result &= this.fontName.equals(font.getFontName());
    }

    public int hashCode() {
        return (String.valueOf(this.fontName) + this.fontSize + "-" + this.fontStyle).hashCode();
    }

    public String getFontName() {
        return this.fontName;
    }

    protected void setFontName(String fontName) {
        this.fontName = fontName;
        if (this.document != null) {
            this.fontNumber = this.document.getDocumentHeader().getFontNumber(this);
        }
    }

    public String getFamilyname() {
        return this.fontName;
    }

    public void setFamily(String family) {
        super.setFamily(family);
        this.setToDefaultFamily(family);
    }

    private void setToDefaultFamily(String familyname) {
        switch (Font.getFamilyIndex(familyname)) {
            case 0: {
                this.fontName = "Courier";
                break;
            }
            case 1: {
                this.fontName = "Arial";
                break;
            }
            case 3: {
                this.fontName = "Symbol";
                this.charset = 2;
                break;
            }
            case 2: {
                this.fontName = "Times New Roman";
                break;
            }
            case 4: {
                this.fontName = "Windings";
                break;
            }
            default: {
                this.fontName = familyname;
            }
        }
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setSize(float size) {
        super.setSize(size);
        this.fontSize = (int)this.size();
    }

    public int getFontStyle() {
        return this.fontStyle;
    }

    public void setStyle(int style) {
        super.setStyle(style);
        this.fontStyle = this.style();
    }

    public void setStyle(String style) {
        super.setStyle(style);
        this.fontStyle = this.style();
    }

    public int getFontNumber() {
        return this.fontNumber;
    }

    public void setRtfDocument(RtfDocument doc) {
        this.document = doc;
        if (this.document != null) {
            this.fontNumber = this.document.getDocumentHeader().getFontNumber(this);
        }
        if (this.color != null) {
            this.color.setRtfDocument(this.document);
        }
    }

    public void setInTable(boolean inTable) {
    }

    public void setInHeader(boolean inHeader) {
    }

    public void setColor(Color color) {
        super.setColor(color);
        this.color = color != null ? new RtfColor(this.document, color) : null;
    }

    public void setColor(int red, int green, int blue) {
        super.setColor(red, green, blue);
        this.color = new RtfColor(this.document, red, green, blue);
    }

    protected byte[] intToByteArray(int i) {
        return Integer.toString(i).getBytes();
    }

    public Font difference(Font font) {
        float dSize;
        String dFamilyname = font.getFamilyname();
        if (dFamilyname == null || dFamilyname.trim().equals("") || dFamilyname.trim().equalsIgnoreCase("unknown")) {
            dFamilyname = this.fontName;
        }
        if ((dSize = font.size()) == -1.0f) {
            dSize = this.size();
        }
        int dStyle = -1;
        if (this.style() != -1 && font.style() != -1) {
            dStyle = this.style() | font.style();
        } else if (this.style() != -1) {
            dStyle = this.style();
        } else if (font.style() != -1) {
            dStyle = font.style();
        }
        Color dColor = font.color();
        if (dColor == null) {
            dColor = this.color();
        }
        return new RtfFont(dFamilyname, dSize, dStyle, dColor);
    }
}

