/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.io.BufferedReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;

class GhemicalMMReader
extends AtomSetCollectionReader {
    GhemicalMMReader() {
    }

    AtomSetCollection readAtomSetCollection(BufferedReader reader) throws Exception {
        this.reader = reader;
        this.atomSetCollection = new AtomSetCollection("ghemicalMM");
        while (this.readLine() != null) {
            if (this.line.startsWith("!Header")) {
                this.processHeader();
                continue;
            }
            if (this.line.startsWith("!Info")) {
                this.processInfo();
                continue;
            }
            if (this.line.startsWith("!Atoms")) {
                this.processAtoms();
                continue;
            }
            if (this.line.startsWith("!Bonds")) {
                this.processBonds();
                continue;
            }
            if (this.line.startsWith("!Coord")) {
                this.processCoord();
                continue;
            }
            if (this.line.startsWith("!Charges")) {
                this.processCharges();
                continue;
            }
            if (!this.line.startsWith("!End")) continue;
            return this.atomSetCollection;
        }
        this.atomSetCollection.errorMessage = "unexpected end of file";
        return this.atomSetCollection;
    }

    void processHeader() {
    }

    void processInfo() {
    }

    void processAtoms() throws Exception {
        int atomCount = this.parseInt(this.line, 6);
        for (int i = 0; i < atomCount; ++i) {
            if (this.atomSetCollection.atomCount != i) {
                throw new Exception("GhemicalMMReader error #1");
            }
            this.readLine();
            int atomIndex = this.parseInt(this.line);
            if (atomIndex != i) {
                throw new Exception("bad atom index in !Atomsexpected: " + i + " saw:" + atomIndex);
            }
            int elementNumber = this.parseInt(this.line, this.ichNextParse);
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.elementNumber = (byte)elementNumber;
        }
    }

    void processBonds() throws Exception {
        int bondCount = this.parseInt(this.line, 6);
        for (int i = 0; i < bondCount; ++i) {
            this.readLine();
            int atomIndex1 = this.parseInt(this.line);
            int atomIndex2 = this.parseInt(this.line, this.ichNextParse);
            String orderCode = this.parseToken(this.line, this.ichNextParse);
            int order = 0;
            switch (orderCode.charAt(0)) {
                case 'C': {
                    ++order;
                }
                case 'T': {
                    ++order;
                }
                case 'D': {
                    ++order;
                }
            }
            this.atomSetCollection.addNewBond(atomIndex1, atomIndex2, ++order);
        }
    }

    void processCoord() throws Exception {
        for (int i = 0; i < this.atomSetCollection.atomCount; ++i) {
            this.readLine();
            int atomIndex = this.parseInt(this.line);
            if (atomIndex != i) {
                throw new Exception("bad atom index in !Coordexpected: " + i + " saw:" + atomIndex);
            }
            Atom atom = this.atomSetCollection.atoms[i];
            atom.x = this.parseFloat(this.line, this.ichNextParse) * 10.0f;
            atom.y = this.parseFloat(this.line, this.ichNextParse) * 10.0f;
            atom.z = this.parseFloat(this.line, this.ichNextParse) * 10.0f;
        }
    }

    void processCharges() throws Exception {
        for (int i = 0; i < this.atomSetCollection.atomCount; ++i) {
            this.readLine();
            int atomIndex = this.parseInt(this.line);
            if (atomIndex != i) {
                throw new Exception("bad atom index in !Chargesexpected: " + i + " saw:" + atomIndex);
            }
            Atom atom = this.atomSetCollection.atoms[i];
            atom.partialCharge = this.parseFloat(this.line, this.ichNextParse);
        }
    }
}

