/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.io.BufferedReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.util.Logger;
import org.jmol.viewer.JmolConstants;

class QchemReader
extends AtomSetCollectionReader {
    int atomCount;

    QchemReader() {
    }

    AtomSetCollection readAtomSetCollection(BufferedReader reader) throws Exception {
        this.reader = reader;
        this.atomSetCollection = new AtomSetCollection("qchem");
        try {
            int lineNum = 0;
            while (this.readLine() != null) {
                if (this.line.indexOf("Standard Nuclear Orientation") >= 0) {
                    this.readAtoms();
                } else {
                    if (this.line.indexOf("VIBRATIONAL FREQUENCIES") >= 0) {
                        this.readFrequencies();
                        break;
                    }
                    if (this.line.indexOf("Mulliken Net Atomic Charges") >= 0) {
                        this.readPartialCharges();
                    }
                }
                ++lineNum;
            }
        }
        catch (Exception ex) {
            Logger.error("Could not read file", ex);
            this.atomSetCollection.errorMessage = "Could not read file:" + ex;
            return this.atomSetCollection;
        }
        if (this.atomSetCollection.atomCount == 0) {
            this.atomSetCollection.errorMessage = "No atoms in file";
        }
        return this.atomSetCollection;
    }

    void readAtoms() throws Exception {
        this.atomSetCollection.discardPreviousAtoms();
        this.atomCount = 0;
        this.discardLines(2);
        while (this.readLine() != null && !this.line.startsWith(" --")) {
            String symbol;
            String[] tokens = this.getTokens(this.line);
            if (tokens.length < 5 || JmolConstants.elementNumberFromSymbol(symbol = tokens[1]) < 1) continue;
            float x = this.parseFloat(tokens[2]);
            float y = this.parseFloat(tokens[3]);
            float z = this.parseFloat(tokens[4]);
            if (Float.isNaN(x) || Float.isNaN(y) || Float.isNaN(z)) continue;
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.elementSymbol = symbol;
            atom.x = x;
            atom.y = y;
            atom.z = z;
            ++this.atomCount;
        }
    }

    void readFrequencies() throws Exception {
        int modelNumber = 1;
        this.discardLinesUntilStartsWith(" Frequency:");
        while (this.line != null && this.line.startsWith(" Frequency:")) {
            String[] frequencies = this.getTokens(this.line);
            int nModels = frequencies.length - 1;
            this.discardLines(4);
            for (int i = 0; i < this.atomCount; ++i) {
                this.readLine();
                String[] tokens = this.getTokens(this.line);
                int offset = 0;
                for (int j = 0; j < nModels; ++j) {
                    float x = this.parseFloat(tokens[++offset]);
                    float y = this.parseFloat(tokens[++offset]);
                    float z = this.parseFloat(tokens[++offset]);
                    this.recordAtomVector(modelNumber + j, i + 1, x, y, z);
                }
            }
            this.discardLines(1);
            modelNumber += 3;
            this.readLine();
        }
    }

    void recordAtomVector(int modelNumber, int atomCenterNumber, float x, float y, float z) {
        if (Float.isNaN(x) || Float.isNaN(y) || Float.isNaN(z)) {
            return;
        }
        if (atomCenterNumber <= 0 || atomCenterNumber > this.atomCount) {
            return;
        }
        if (atomCenterNumber == 1 && modelNumber > 1) {
            this.atomSetCollection.cloneFirstAtomSet();
        }
        Atom atom = this.atomSetCollection.atoms[(modelNumber - 1) * this.atomCount + atomCenterNumber - 1];
        atom.vectorX = x;
        atom.vectorY = y;
        atom.vectorZ = z;
    }

    void readPartialCharges() throws Exception {
        this.discardLines(3);
        for (int i = 0; i < this.atomCount && this.readLine() != null; ++i) {
            this.atomSetCollection.atoms[i].partialCharge = this.parseFloat(this.getTokens(this.line)[2]);
        }
    }
}

