/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.io.BufferedReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.viewer.JmolConstants;

class XyzReader
extends AtomSetCollectionReader {
    final float[] chargeAndOrVector = new float[4];
    final boolean[] isNaN = new boolean[4];

    XyzReader() {
    }

    AtomSetCollection readAtomSetCollection(BufferedReader reader) throws Exception {
        this.reader = reader;
        this.atomSetCollection = new AtomSetCollection("xyz");
        boolean iHaveAtoms = false;
        try {
            int modelAtomCount;
            while ((modelAtomCount = this.readAtomCount()) > 0) {
                if (++this.modelNumber != this.desiredModelNumber && this.desiredModelNumber > 0) {
                    if (!iHaveAtoms) {
                        this.skipAtomSet(modelAtomCount);
                        continue;
                    }
                    break;
                }
                iHaveAtoms = true;
                this.readAtomSetName();
                this.readAtoms(modelAtomCount);
                this.applySymmetry();
            }
        }
        catch (Exception ex) {
            this.atomSetCollection.errorMessage = "Could not read file:" + ex;
        }
        return this.atomSetCollection;
    }

    void skipAtomSet(int modelAtomCount) throws Exception {
        this.readLine();
        int i = modelAtomCount;
        while (--i >= 0) {
            this.readLine();
        }
    }

    int readAtomCount() throws Exception {
        int atomCount;
        this.readLine();
        if (this.line != null && (atomCount = this.parseInt(this.line)) > 0) {
            return atomCount;
        }
        return 0;
    }

    void readAtomSetName() throws Exception {
        this.readLineTrimmed();
        this.checkLineForScript();
        this.newAtomSet(this.line);
    }

    void readAtoms(int modelAtomCount) throws Exception {
        for (int i = 0; i < modelAtomCount; ++i) {
            this.readLine();
            Atom atom = this.atomSetCollection.addNewAtom();
            int isotope = this.parseInt(this.line);
            String str = this.parseToken(this.line);
            if (isotope == Integer.MIN_VALUE) {
                atom.elementSymbol = str;
            } else {
                str = str.substring(("" + isotope).length());
                atom.elementNumber = (short)((isotope << 7) + JmolConstants.elementNumberFromSymbol(str));
                this.atomSetCollection.setFileTypeName("xyzi");
            }
            atom.x = this.parseFloat(this.line, this.ichNextParse);
            atom.y = this.parseFloat(this.line, this.ichNextParse);
            atom.z = this.parseFloat(this.line, this.ichNextParse);
            if (Float.isNaN(atom.x) || Float.isNaN(atom.y) || Float.isNaN(atom.z)) {
                this.logger.log("line cannot be read for XYZ atom data: " + this.line);
                atom.x = 0.0f;
                atom.y = 0.0f;
                atom.z = 0.0f;
            }
            this.setAtomCoord(atom);
            for (int j = 0; j < 4; ++j) {
                this.chargeAndOrVector[j] = this.parseFloat(this.line, this.ichNextParse);
                this.isNaN[j] = Float.isNaN(this.chargeAndOrVector[j]);
            }
            if (this.isNaN[0]) continue;
            if (this.isNaN[1]) {
                atom.formalCharge = (int)this.chargeAndOrVector[0];
                continue;
            }
            if (this.isNaN[3]) {
                atom.vectorX = this.chargeAndOrVector[0];
                atom.vectorY = this.chargeAndOrVector[1];
                atom.vectorZ = this.chargeAndOrVector[2];
                continue;
            }
            atom.formalCharge = (int)this.chargeAndOrVector[0];
            atom.vectorX = this.chargeAndOrVector[1];
            atom.vectorY = this.chargeAndOrVector[2];
            atom.vectorZ = this.chargeAndOrVector[3];
        }
    }
}

