/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

public class Int2ObjHash {
    int entryCount;
    Entry[] entries;

    public Int2ObjHash(int initialCapacity) {
        this.entries = new Entry[initialCapacity];
    }

    public Int2ObjHash() {
        this(256);
    }

    public synchronized Object get(int key) {
        Entry[] entries = this.entries;
        int hash = (key & Integer.MAX_VALUE) % entries.length;
        Entry e = entries[hash];
        while (e != null) {
            if (e.key == key) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    public synchronized void put(int key, Object value) {
        Entry[] entries = this.entries;
        int hash = (key & Integer.MAX_VALUE) % entries.length;
        Entry e = entries[hash];
        while (e != null) {
            if (e.key == key) {
                e.value = value;
                return;
            }
            e = e.next;
        }
        if (this.entryCount > entries.length) {
            this.rehash();
        }
        entries = this.entries;
        hash = (key & Integer.MAX_VALUE) % entries.length;
        entries[hash] = new Entry(key, value, entries[hash]);
        ++this.entryCount;
    }

    private void rehash() {
        Entry[] oldEntries = this.entries;
        int oldSize = oldEntries.length;
        int newSize = oldSize * 2 + 1;
        Entry[] newEntries = new Entry[newSize];
        int i = oldSize;
        while (--i >= 0) {
            Entry e = oldEntries[i];
            while (e != null) {
                Entry t = e;
                e = e.next;
                int hash = (t.key & Integer.MAX_VALUE) % newSize;
                t.next = newEntries[hash];
                newEntries[hash] = t;
            }
        }
        this.entries = newEntries;
    }

    static class Entry {
        int key;
        Object value;
        Entry next;

        Entry(int key, Object value, Entry next) {
            this.key = key;
            this.value = value;
            this.next = next;
        }
    }
}

