/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.viewer.Monomer;
import org.jmol.viewer.Mps;
import org.jmol.viewer.MpsRenderer;
import org.jmol.viewer.NucleicPolymer;
import org.jmol.viewer.Ribbons;

class RibbonsRenderer
extends MpsRenderer {
    Ribbons strands;
    final Point3f pointT = new Point3f();
    boolean isNucleic;
    boolean ribbonBorder = false;
    int myVisibilityFlag;

    RibbonsRenderer() {
    }

    Point3i[] calcScreens(Point3f[] centers, Vector3f[] vectors, short[] mads, float offsetFraction) {
        Point3i[] screens = this.viewer.allocTempScreens(centers.length);
        if (offsetFraction == 0.0f) {
            int i = centers.length;
            while (--i >= 0) {
                this.viewer.transformPoint(centers[i], screens[i]);
            }
        } else {
            offsetFraction /= 1000.0f;
            int i = centers.length;
            while (--i >= 0) {
                this.pointT.set(vectors[i]);
                float scale = (float)mads[i] * offsetFraction;
                this.pointT.scaleAdd(scale, centers[i]);
                this.viewer.transformPoint(this.pointT, screens[i]);
            }
        }
        return screens;
    }

    void renderMpspolymer(Mps.Mpspolymer mpspolymer, int myVisibilityFlag) {
        this.myVisibilityFlag = myVisibilityFlag;
        Ribbons.Schain strandsChain = (Ribbons.Schain)mpspolymer;
        if (strandsChain.wingVectors != null) {
            this.ribbonBorder = this.viewer.getRibbonBorder();
            this.isNucleic = strandsChain.polymer instanceof NucleicPolymer;
            this.render1Chain(strandsChain.monomerCount, strandsChain.monomers, strandsChain.leadMidpoints, strandsChain.wingVectors, strandsChain.mads, strandsChain.colixes);
        }
    }

    void render1Chain(int monomerCount, Monomer[] monomers, Point3f[] centers, Vector3f[] vectors, short[] mads, short[] colixes) {
        Point3i[] ribbonTopScreens = this.calcScreens(centers, vectors, mads, this.isNucleic ? 1.0f : 0.5f);
        Point3i[] ribbonBottomScreens = this.calcScreens(centers, vectors, mads, this.isNucleic ? 0.0f : -0.5f);
        this.render2Strand(monomerCount, monomers, mads, colixes, ribbonTopScreens, ribbonBottomScreens);
        this.viewer.freeTempScreens(ribbonTopScreens);
        this.viewer.freeTempScreens(ribbonBottomScreens);
    }

    void render2Strand(int monomerCount, Monomer[] monomers, short[] mads, short[] colixes, Point3i[] ribbonTopScreens, Point3i[] ribbonBottomScreens) {
        int i = monomerCount;
        while (--i >= 0) {
            if ((monomers[i].shapeVisibilityFlags & this.myVisibilityFlag) == 0 || this.frame.bsHidden.get(monomers[i].getLeadAtomIndex())) continue;
            this.render2StrandSegment(monomerCount, monomers[i], colixes[i], mads, ribbonTopScreens, ribbonBottomScreens, i);
        }
    }

    void render2StrandSegment(int monomerCount, Monomer monomer, short colix, short[] mads, Point3i[] ribbonTopScreens, Point3i[] ribbonBottomScreens, int i) {
        int iNext2;
        int iNext;
        int iLast = monomerCount;
        int iPrev = i - 1;
        if (iPrev < 0) {
            iPrev = 0;
        }
        if ((iNext = i + 1) > iLast) {
            iNext = iLast;
        }
        if ((iNext2 = i + 2) > iLast) {
            iNext2 = iLast;
        }
        colix = Graphics3D.inheritColix(colix, monomer.getLeadAtom().colixAtom);
        this.g3d.drawHermite(true, this.ribbonBorder, colix, this.isNucleic ? 4 : 7, ribbonTopScreens[iPrev], ribbonTopScreens[i], ribbonTopScreens[iNext], ribbonTopScreens[iNext2], ribbonBottomScreens[iPrev], ribbonBottomScreens[i], ribbonBottomScreens[iNext], ribbonBottomScreens[iNext2]);
    }
}

