/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.viewer.Atom;
import org.jmol.viewer.ShapeRenderer;
import org.jmol.viewer.Vectors;

class VectorsRenderer
extends ShapeRenderer {
    final Point3f pointVectorEnd = new Point3f();
    final Point3f pointArrowHead = new Point3f();
    final Point3i screenVectorEnd = new Point3i();
    final Point3i screenArrowHead = new Point3i();
    final Vector3f vibrationVectorScaled = new Vector3f();
    int diameter;
    float headWidthAngstroms;
    int headWidthPixels;
    static final float arrowHeadBase = 0.8f;

    VectorsRenderer() {
    }

    void render() {
        if (!this.frame.hasVibrationVectors) {
            return;
        }
        Atom[] atoms = this.frame.atoms;
        Vectors vectors = (Vectors)this.shape;
        short[] mads = vectors.mads;
        if (mads == null) {
            return;
        }
        short[] colixes = vectors.colixes;
        int i = this.frame.atomCount;
        while (--i >= 0) {
            Vector3f vibrationVector;
            Atom atom = atoms[i];
            if ((atom.shapeVisibilityFlags & 1) == 0 || (atom.shapeVisibilityFlags & vectors.myVisibilityFlag) == 0 || this.frame.bsHidden.get(i) || (vibrationVector = atom.getVibrationVector()) == null || !this.transform(mads[i], atom, vibrationVector)) continue;
            this.renderVector(colixes[i], atom);
        }
    }

    boolean transform(short mad, Atom atom, Vector3f vibrationVector) {
        if (atom.madAtom == Short.MIN_VALUE) {
            return false;
        }
        float vectorScale = this.viewer.getVectorScale();
        this.pointVectorEnd.scaleAdd(vectorScale, vibrationVector, atom);
        this.viewer.transformPoint(this.pointVectorEnd, vibrationVector, this.screenVectorEnd);
        this.diameter = mad <= 20 ? mad : this.viewer.scaleToScreen(this.screenVectorEnd.z, mad);
        this.pointArrowHead.scaleAdd(vectorScale * 0.8f, vibrationVector, atom);
        this.viewer.transformPoint(this.pointArrowHead, vibrationVector, this.screenArrowHead);
        this.headWidthPixels = this.diameter * 3 / 2;
        if (this.headWidthPixels < this.diameter + 2) {
            this.headWidthPixels = this.diameter + 2;
        }
        return true;
    }

    void renderVector(short colix, Atom atom) {
        colix = Graphics3D.inheritColix(colix, atom.colixAtom);
        this.g3d.fillCylinder(colix, (byte)1, this.diameter, atom.getScreenX(), atom.getScreenY(), atom.getScreenZ(), this.screenArrowHead.x, this.screenArrowHead.y, this.screenArrowHead.z);
        this.g3d.fillCone(colix, (byte)2, this.headWidthPixels, this.screenArrowHead, this.screenVectorEnd);
    }
}

