/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.applications.jchempaint.action;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import javax.swing.JFileChooser;
import org.openscience.cdk.Molecule;
import org.openscience.cdk.applications.jchempaint.action.SaveAction;
import org.openscience.cdk.applications.jchempaint.io.JCPCompChemInputSaveFileFilter;
import org.openscience.cdk.applications.jchempaint.io.JCPFileView;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.io.listener.IChemObjectIOListener;
import org.openscience.cdk.io.listener.SwingGUIListener;
import org.openscience.cdk.io.program.GaussianInputWriter;
import org.openscience.cdk.tools.manipulator.ChemModelManipulator;

public class ExportCompChemAction
extends SaveAction {
    private static final long serialVersionUID = -407195104869621963L;

    public void actionPerformed(ActionEvent e) {
        JFileChooser chooser = new JFileChooser();
        chooser.setCurrentDirectory(this.jcpPanel.getCurrentWorkDirectory());
        JCPCompChemInputSaveFileFilter.addChoosableFileFilters(chooser);
        chooser.setFileView(new JCPFileView());
        int returnVal = chooser.showSaveDialog(this.jcpPanel);
        String type = null;
        if (returnVal == 0) {
            type = ((JCPCompChemInputSaveFileFilter)chooser.getFileFilter()).getType();
            File outFile = chooser.getSelectedFile();
            if (type.equals("gin")) {
                logger.info((Object)"Saving the contents as Gaussian input...");
                try {
                    IAtomContainer ac;
                    this.cow = new GaussianInputWriter((Writer)new FileWriter(outFile));
                    if (this.cow != null) {
                        this.cow.addChemObjectIOListener((IChemObjectIOListener)new SwingGUIListener((Component)this.jcpPanel, 4));
                    }
                    if ((ac = ChemModelManipulator.getAllInOneContainer((IChemModel)this.jcpPanel.getJChemPaintModel().getChemModel())) != null) {
                        this.cow.write((IChemObject)new Molecule(ac));
                    } else {
                        logger.error((Object)"AtomContainer is empty!!!");
                        System.err.println("AC == null!");
                    }
                }
                catch (Exception exception) {
                    logger.error((Object)"Exception while trying to save Gaussian input");
                    logger.debug((Object)exception);
                }
            }
        }
        this.jcpPanel.setCurrentWorkDirectory(chooser.getCurrentDirectory());
    }
}

