/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.controller.edit;

import java.util.Set;
import javax.vecmath.Point2d;
import org.openscience.cdk.controller.Changed;
import org.openscience.cdk.controller.edit.AbstractEdit;
import org.openscience.cdk.controller.edit.IEdit;
import org.openscience.cdk.interfaces.IAtom;

public class AddAtom
extends AbstractEdit
implements IEdit {
    Point2d position;
    String symbol;
    IAtom addedAtom;

    public static AddAtom createAtom(String symbol, Point2d position) {
        return new AddAtom(symbol, position);
    }

    private AddAtom(String symbol, Point2d position) {
        this.symbol = symbol;
        this.position = position;
    }

    @Override
    public void redo() {
        if (this.addedAtom == null) {
            this.addedAtom = (IAtom)this.model.getBuilder().newInstance(IAtom.class, new Object[]{this.symbol, this.position});
        }
        this.model.addAtom(this.addedAtom);
        this.updateHydrogenCount(this.addedAtom);
    }

    @Override
    public void undo() {
        this.model.removeAtom(this.addedAtom);
    }

    @Override
    public Set<Changed> getTypeOfChanges() {
        return AddAtom.changed(Changed.Structure);
    }
}

