/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.math.qm;

import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.math.Matrix;
import org.openscience.cdk.math.Vector;
import org.openscience.cdk.math.qm.IBasis;

public class GaussiansBasis
implements IBasis {
    private int count;
    private int[] nx;
    private int[] ny;
    private int[] nz;
    private double[] alpha;
    private double[] norm;
    private Vector[] r;
    private int count_atoms;
    private Vector[] rN;
    private int[] oz;
    private double minx = 0.0;
    private double maxx = 0.0;
    private double miny = 0.0;
    private double maxy = 0.0;
    private double minz = 0.0;
    private double maxz = 0.0;

    public GaussiansBasis() {
    }

    public GaussiansBasis(int[] nx, int[] ny, int[] nz, double[] alpha, Vector[] r, IAtom[] atoms) {
        this.setBasis(nx, ny, nz, alpha, r, atoms);
    }

    protected void setBasis(int[] nx, int[] ny, int[] nz, double[] alpha, Vector[] r, IAtom[] atoms) {
        int i;
        this.count_atoms = atoms.length;
        this.rN = new Vector[this.count_atoms];
        this.oz = new int[this.count_atoms];
        for (i = 0; i < this.count_atoms; ++i) {
            this.rN[i] = new Vector(atoms[i].getPoint3d()).mul(1.8897);
            this.oz[i] = atoms[i].getAtomicNumber();
        }
        this.count = Math.min(nx.length, Math.min(ny.length, Math.min(nz.length, alpha.length)));
        this.nx = new int[this.count];
        this.ny = new int[this.count];
        this.nz = new int[this.count];
        this.alpha = new double[this.count];
        this.norm = new double[this.count];
        this.r = new Vector[this.count];
        this.oz = new int[this.count];
        for (i = 0; i < this.count; ++i) {
            this.nx[i] = nx[i];
            this.ny[i] = ny[i];
            this.nz[i] = nz[i];
            this.alpha[i] = alpha[i];
            this.r[i] = r[i].mul(1.8897);
            this.norm[i] = Math.sqrt(this.calcS(i, i));
            this.norm[i] = this.norm[i] == 0.0 ? 1.0 : 1.0 / this.norm[i];
            if (i > 0) {
                this.minx = Math.min(this.minx, this.r[i].vector[0]);
                this.maxx = Math.max(this.maxx, this.r[i].vector[0]);
                this.miny = Math.min(this.miny, this.r[i].vector[1]);
                this.maxy = Math.max(this.maxy, this.r[i].vector[1]);
                this.minz = Math.min(this.minz, this.r[i].vector[2]);
                this.maxz = Math.max(this.maxz, this.r[i].vector[2]);
                continue;
            }
            this.minx = r[0].vector[0];
            this.maxx = r[0].vector[0];
            this.miny = r[0].vector[1];
            this.maxy = r[0].vector[1];
            this.minz = r[0].vector[2];
            this.maxz = r[0].vector[2];
        }
        this.minx -= 2.0;
        this.maxx += 2.0;
        this.miny -= 2.0;
        this.maxy += 2.0;
        this.minz -= 2.0;
        this.maxz += 2.0;
    }

    @Override
    public int getSize() {
        return this.count;
    }

    @Override
    public double getMinX() {
        return this.minx;
    }

    @Override
    public double getMaxX() {
        return this.maxx;
    }

    @Override
    public double getMinY() {
        return this.miny;
    }

    @Override
    public double getMaxY() {
        return this.maxy;
    }

    @Override
    public double getMinZ() {
        return this.minz;
    }

    @Override
    public double getMaxZ() {
        return this.maxz;
    }

    @Override
    public double getValue(int index, double x, double y, double z) {
        int i;
        double dx = x * 1.8897 - this.r[index].vector[0];
        double dy = y * 1.8897 - this.r[index].vector[1];
        double dz = z * 1.8897 - this.r[index].vector[2];
        double result = 1.0;
        for (i = 0; i < this.nx[index]; ++i) {
            result *= dx;
        }
        for (i = 0; i < this.ny[index]; ++i) {
            result *= dy;
        }
        for (i = 0; i < this.nz[index]; ++i) {
            result *= dz;
        }
        return result * Math.exp(-this.alpha[index] * (dx * dx + dy * dy + dz * dz));
    }

    @Override
    public Vector getValues(int index, Matrix m) {
        int i;
        if (m.rows != 3) {
            return null;
        }
        double x = m.matrix[0][0];
        double y = m.matrix[1][0];
        double z = m.matrix[2][0];
        double dx = x * 1.8897 - this.r[index].vector[0];
        double dy = y * 1.8897 - this.r[index].vector[1];
        double dz = z * 1.8897 - this.r[index].vector[2];
        Vector result = new Vector(m.columns);
        double mx = 1.0;
        for (i = 0; i < this.nx[index]; ++i) {
            mx *= dx;
        }
        double my = 1.0;
        for (i = 0; i < this.ny[index]; ++i) {
            my *= dy;
        }
        double mz = 1.0;
        for (i = 0; i < this.nz[index]; ++i) {
            mz *= dz;
        }
        dx *= dx;
        dy *= dy;
        dz *= dz;
        result.vector[0] = mx * my * mz * Math.exp(-this.alpha[index] * (dx + dy + dz));
        for (int j = 1; j < m.columns; ++j) {
            if (x != m.matrix[0][j]) {
                x = m.matrix[0][j];
                dx = x * 1.8897 - this.r[index].vector[0];
                mx = 1.0;
                for (i = 0; i < this.nx[index]; ++i) {
                    mx *= dx;
                }
                dx *= dx;
            }
            if (y != m.matrix[1][j]) {
                y = m.matrix[1][j];
                dy = y * 1.8897 - this.r[index].vector[1];
                my = 1.0;
                for (i = 0; i < this.ny[index]; ++i) {
                    my *= dy;
                }
                dy *= dy;
            }
            if (z != m.matrix[2][j]) {
                z = m.matrix[2][j];
                dz = z * 1.8897 - this.r[index].vector[2];
                mz = 1.0;
                for (i = 0; i < this.nz[index]; ++i) {
                    mz *= dz;
                }
                dz *= dz;
            }
            result.vector[j] = mx * my * mz * Math.exp(-this.alpha[index] * (dx + dy + dz));
        }
        return result;
    }

    public Vector getPosition(int index) {
        return this.r[index].duplicate().mul(0.52918);
    }

    public double calcD(double normi, double normj, double alphai, double alphaj, Vector ri, Vector rj) {
        double dx = ri.vector[0] - rj.vector[0];
        double dy = ri.vector[1] - rj.vector[1];
        double dz = ri.vector[2] - rj.vector[2];
        return Math.exp(-(alphai * alphaj / (alphai + alphaj)) * (dx * dx + dy * dy + dz * dz)) * normi * normj;
    }

    private double calcI(int ni, int nj, double alphai, double alphaj, double xi, double xj) {
        if (ni < 0 || nj < 0) {
            System.err.println("Error [Basis.calcI()]: nj=" + nj);
            return Double.NaN;
        }
        double[][] I = new double[nj + 1][];
        double alphaij = alphai + alphaj;
        double xij = (alphai * xi + alphaj * xj) / alphaij;
        I[0] = new double[nj + ni + 1];
        I[0][0] = Math.sqrt(Math.PI) / Math.sqrt(alphaij);
        if (nj + ni + 1 > 1) {
            I[0][1] = -(xi - xij) * I[0][0];
            for (int i = 2; i <= nj + ni; ++i) {
                I[0][i] = (double)(i - 1) / (2.0 * alphaij) * I[0][i - 2] - (xi - xij) * I[0][i - 1];
            }
            for (int j = 1; j <= nj; ++j) {
                I[j] = new double[nj + ni + 1 - j];
                for (int i = 0; i <= nj + ni - j; ++i) {
                    I[j][i] = I[nj - 1][ni + 1] + (xi - xj) * I[nj - 1][ni];
                }
            }
        }
        return I[nj][ni];
    }

    @Override
    public double calcS(int i, int j) {
        return this.calcD(this.norm[i], this.norm[j], this.alpha[i], this.alpha[j], this.r[i], this.r[j]) * this.calcI(this.nx[i], this.nx[j], this.alpha[i], this.alpha[j], this.r[i].vector[0], this.r[j].vector[0]) * this.calcI(this.ny[i], this.ny[j], this.alpha[i], this.alpha[j], this.r[i].vector[1], this.r[j].vector[1]) * this.calcI(this.nz[i], this.nz[j], this.alpha[i], this.alpha[j], this.r[i].vector[2], this.r[j].vector[2]);
    }

    public double calcJ(int ni, int nj, double alphai, double alphaj, double xi, double xj) {
        if (ni > 1) {
            return -4.0 * alphai * alphai * this.calcI(ni + 2, nj, alphai, alphaj, xi, xj) + 2.0 * alphai * (double)(2 * ni + 1) * this.calcI(ni, nj, alphai, alphaj, xi, xj) - (double)(ni * (ni - 1)) * this.calcI(ni - 2, nj, alphai, alphaj, xi, xj);
        }
        if (ni == 1) {
            return -4.0 * alphai * alphai * this.calcI(3, nj, alphai, alphaj, xi, xj) + 6.0 * alphai * this.calcI(1, nj, alphai, alphaj, xi, xj);
        }
        if (ni == 0) {
            return -4.0 * alphai * alphai * this.calcI(2, nj, alphai, alphaj, xi, xj) + 2.0 * alphai * this.calcI(0, nj, alphai, alphaj, xi, xj);
        }
        System.err.println("Error [Basis.calcJ]: ni=" + ni);
        return Double.NaN;
    }

    @Override
    public double calcJ(int i, int j) {
        return this.calcD(this.norm[i], this.norm[j], this.alpha[i], this.alpha[j], this.r[i], this.r[j]) * (this.calcJ(this.nx[i], this.nx[j], this.alpha[i], this.alpha[j], this.r[i].vector[0], this.r[j].vector[0]) * this.calcI(this.ny[i], this.ny[j], this.alpha[i], this.alpha[j], this.r[i].vector[1], this.r[j].vector[1]) * this.calcI(this.nz[i], this.nz[j], this.alpha[i], this.alpha[j], this.r[i].vector[2], this.r[j].vector[2]) + this.calcI(this.nx[i], this.nx[j], this.alpha[i], this.alpha[j], this.r[i].vector[0], this.r[j].vector[0]) * this.calcJ(this.ny[i], this.ny[j], this.alpha[i], this.alpha[j], this.r[i].vector[1], this.r[j].vector[1]) * this.calcI(this.nz[i], this.nz[j], this.alpha[i], this.alpha[j], this.r[i].vector[2], this.r[j].vector[2]) + this.calcI(this.nx[i], this.nx[j], this.alpha[i], this.alpha[j], this.r[i].vector[0], this.r[j].vector[0]) * this.calcI(this.ny[i], this.ny[j], this.alpha[i], this.alpha[j], this.r[i].vector[1], this.r[j].vector[1]) * this.calcJ(this.nz[i], this.nz[j], this.alpha[i], this.alpha[j], this.r[i].vector[2], this.r[j].vector[2]));
    }

    public double calcG(int n, double t, double alphai, double alphaj, double xi, double xj, double xN) {
        if (n > 1) {
            return (double)(n - 1) / (2.0 * (alphai + alphaj)) * this.calcG(n - 2, t, alphai, alphaj, xi, xj, xN) - (double)(n - 1) * t * t * this.calcG(n - 2, t, alphai, alphaj, xi, xj, xN) + ((alphai * xi + alphaj * xj) / (alphai + alphaj) - xi) * this.calcG(n - 1, t, alphai, alphaj, xi, xj, xN) + ((alphai * xi + alphaj * xj) / (alphai + alphaj) - xN) * t * t * this.calcG(n - 1, t, alphai, alphaj, xi, xj, xN);
        }
        if (n == 1) {
            return ((alphai * xi + alphaj * xj) / (alphai + alphaj) - xi) * this.calcG(0, t, alphai, alphaj, xi, xj, xN) + ((alphai * xi + alphaj * xj) / (alphai + alphaj) - xN) * t * t * this.calcG(0, t, alphai, alphaj, xi, xj, xN);
        }
        if (n == 0) {
            return Math.sqrt(Math.PI) / Math.sqrt(alphai + alphaj);
        }
        System.err.println("Error [Basis.calcG]: n=" + n);
        return Double.NaN;
    }

    private double calcI(int ni, int nj, double t, double alphai, double alphaj, double xi, double xj, double xN) {
        if (nj > 0) {
            return this.calcI(ni + 1, nj - 1, t, alphai, alphaj, xi, xj, xN) + (xi - xj) * this.calcI(ni, nj - 1, t, alphai, alphaj, xi, xj, xN);
        }
        if (nj == 0) {
            return this.calcG(ni, t, alphai, alphaj, xi, xj, xN);
        }
        System.err.println("Error [Basis.calcI()]: nj=" + nj);
        return Double.NaN;
    }

    public double calcV(int i, int j, Vector rN, double Z) {
        double t;
        double f;
        int steps = 10;
        double h = 1.0 / (double)steps;
        double alphaij = this.alpha[i] + this.alpha[j];
        double rxij = (this.alpha[i] * this.r[i].vector[0] + this.alpha[j] * this.r[j].vector[0]) / alphaij;
        double ryij = (this.alpha[i] * this.r[i].vector[1] + this.alpha[j] * this.r[j].vector[1]) / alphaij;
        double rzij = (this.alpha[i] * this.r[i].vector[2] + this.alpha[j] * this.r[j].vector[2]) / alphaij;
        double X = alphaij * ((rxij - rN.vector[0]) * (rxij - rN.vector[0]) + (ryij - rN.vector[1]) * (ryij - rN.vector[1]) + (rzij - rN.vector[2]) * (rzij - rN.vector[2]));
        double C = 2.0 * this.calcD(this.norm[i], this.norm[j], this.alpha[i], this.alpha[j], this.r[i], this.r[j]) * Math.sqrt(alphaij) / Math.sqrt(Math.PI);
        double sum1 = 0.0;
        for (f = 1.0; f < (double)steps; f += 2.0) {
            t = f * h;
            sum1 += Math.exp(-X * t * t) * this.calcI(this.nx[i], this.nx[j], t, this.alpha[i], this.alpha[j], this.r[i].vector[0], this.r[j].vector[0], rN.vector[0]) * this.calcI(this.ny[i], this.ny[j], t, this.alpha[i], this.alpha[j], this.r[i].vector[1], this.r[j].vector[1], rN.vector[1]) * this.calcI(this.nz[i], this.nz[j], t, this.alpha[i], this.alpha[j], this.r[i].vector[2], this.r[j].vector[2], rN.vector[2]);
        }
        double sum2 = 0.0;
        for (f = 2.0; f < (double)steps; f += 2.0) {
            t = f * h;
            sum2 += Math.exp(-X * t * t) * this.calcI(this.nx[i], this.nx[j], t, this.alpha[i], this.alpha[j], this.r[i].vector[0], this.r[j].vector[0], rN.vector[0]) * this.calcI(this.ny[i], this.ny[j], t, this.alpha[i], this.alpha[j], this.r[i].vector[1], this.r[j].vector[1], rN.vector[1]) * this.calcI(this.nz[i], this.nz[j], t, this.alpha[i], this.alpha[j], this.r[i].vector[2], this.r[j].vector[2], rN.vector[2]);
        }
        t = 0.0;
        double f1 = Math.exp(-X * t * t) * this.calcI(this.nx[i], this.nx[j], t, this.alpha[i], this.alpha[j], this.r[i].vector[0], this.r[j].vector[0], rN.vector[0]) * this.calcI(this.ny[i], this.ny[j], t, this.alpha[i], this.alpha[j], this.r[i].vector[1], this.r[j].vector[1], rN.vector[1]) * this.calcI(this.nz[i], this.nz[j], t, this.alpha[i], this.alpha[j], this.r[i].vector[2], this.r[j].vector[2], rN.vector[2]);
        t = 1.0;
        double f2 = Math.exp(-X * t * t) * this.calcI(this.nx[i], this.nx[j], t, this.alpha[i], this.alpha[j], this.r[i].vector[0], this.r[j].vector[0], rN.vector[0]) * this.calcI(this.ny[i], this.ny[j], t, this.alpha[i], this.alpha[j], this.r[i].vector[1], this.r[j].vector[1], rN.vector[1]) * this.calcI(this.nz[i], this.nz[j], t, this.alpha[i], this.alpha[j], this.r[i].vector[2], this.r[j].vector[2], rN.vector[2]);
        return h / 3.0 * (f1 + 4.0 * sum1 + 2.0 * sum2 + f2) * Z * C;
    }

    @Override
    public double calcV(int i, int j) {
        double result = 0.0;
        for (int k = 0; k < this.count_atoms; ++k) {
            result += this.calcV(i, j, this.rN[k], this.oz[k]);
        }
        return -result;
    }

    public double calcG(int n, int m, double u, double alphai, double alphaj, double alphak, double alphal, double xi, double xj, double xk, double xl) {
        int i;
        if (n < 0 || m < 0) {
            return Double.NaN;
        }
        double alphaij = alphai + alphaj;
        double alphakl = alphak + alphal;
        double xij = (alphai * xi + alphaj * xj) / alphaij;
        double xkl = (alphak * xk + alphal * xl) / alphakl;
        double C00 = xij - xi - u * u * alphakl * (xij - xkl) / (u * u * (alphaij + alphakl) + alphaij * alphakl);
        double Cs00 = xkl - xk + u * u * alphaij * (xij - xkl) / (u * u * (alphaij + alphakl) + alphaij * alphakl);
        double B00 = u * u / (2.0 * (u * u * (alphaij + alphakl) + alphaij * alphakl));
        double B10 = (u * u + alphakl) / (2.0 * (u * u * (alphaij + alphakl) + alphaij * alphakl));
        double Bs01 = (u * u + alphaij) / (2.0 * (u * u * (alphaij + alphakl) + alphaij * alphakl));
        double[][] G = new double[n + 1][m + 1];
        G[0][0] = 1.0;
        if (n > 0) {
            G[1][0] = C00;
        }
        for (i = 2; i <= n; ++i) {
            G[i][0] = (double)(i - 1) * B10 * G[i - 2][0] + C00 * G[i - 1][0];
        }
        if (m > 0) {
            G[0][1] = Cs00;
        }
        for (i = 2; i <= m; ++i) {
            G[0][i] = (double)(i - 1) * Bs01 * G[0][i - 2] + Cs00 * G[0][i - 1];
        }
        if (n > 0) {
            for (i = 1; i <= m; ++i) {
                G[1][i] = (double)i * B00 * G[0][i - 1] + C00 * G[0][i];
            }
        }
        for (i = 2; i <= n; ++i) {
            for (int j = 1; j <= m; ++j) {
                G[i][j] = (double)(i - 1) * B10 * G[i - 2][j] + (double)j * B00 * G[i - 1][j - 1] + C00 * G[i - 1][j];
            }
        }
        return G[n][m];
    }

    public double calcI(int ni, int nj, int nk, int nl, double u, double alphai, double alphaj, double alphak, double alphal, double xi, double xj, double xk, double xl) {
        if (nj > 0) {
            return this.calcI(ni + 1, nj - 1, nk, nl, u, alphai, alphaj, alphak, alphal, xi, xj, xk, xl) + (xj - xi) * this.calcI(ni, nj - 1, nk, nl, u, alphai, alphaj, alphak, alphal, xi, xj, xk, xl);
        }
        if (nl > 0) {
            return this.calcI(ni, nj, nk + 1, nl - 1, u, alphai, alphaj, alphak, alphal, xi, xj, xk, xl) + (xl - xk) * this.calcI(ni, nj, nk, nl - 1, u, alphai, alphaj, alphak, alphal, xi, xj, xk, xl);
        }
        if (ni == 0 && nj == 0 && nk == 0 && nl == 0) {
            return 1.0;
        }
        if (nj == 0 && nl == 0) {
            return this.calcG(ni, nk, u, alphai, alphaj, alphak, alphal, xi, xj, xk, xl);
        }
        return Double.NaN;
    }

    @Override
    public double calcI(int i, int j, int k, int l) {
        double t;
        double f;
        int steps = 10;
        double h = 1.0 / (double)steps;
        double alphaij = this.alpha[i] + this.alpha[j];
        double alphakl = this.alpha[k] + this.alpha[l];
        double rxij = (this.alpha[i] * this.r[i].vector[0] + this.alpha[j] * this.r[j].vector[0]) / alphaij;
        double ryij = (this.alpha[i] * this.r[i].vector[1] + this.alpha[j] * this.r[j].vector[1]) / alphaij;
        double rzij = (this.alpha[i] * this.r[i].vector[2] + this.alpha[j] * this.r[j].vector[2]) / alphaij;
        double rxkl = (this.alpha[k] * this.r[k].vector[0] + this.alpha[l] * this.r[l].vector[0]) / alphakl;
        double rykl = (this.alpha[k] * this.r[k].vector[1] + this.alpha[l] * this.r[l].vector[1]) / alphakl;
        double rzkl = (this.alpha[k] * this.r[k].vector[2] + this.alpha[l] * this.r[l].vector[2]) / alphakl;
        double alpha0 = alphaij * alphakl / (alphaij + alphakl);
        double X = alpha0 * ((rxij - rxkl) * (rxij - rxkl) + (ryij - rykl) * (ryij - rzkl) + (rzij - rzkl) * (rzij - rzkl));
        double C = 31.006276680299816 / Math.pow((this.alpha[i] + this.alpha[j]) * (this.alpha[k] + this.alpha[l]), 1.5) * Math.sqrt(alpha0) * this.calcD(this.norm[i], this.norm[j], this.alpha[i], this.alpha[j], this.r[i], this.r[j]) * this.calcD(this.norm[k], this.norm[l], this.alpha[k], this.alpha[l], this.r[k], this.r[l]) * (2.0 / Math.sqrt(Math.PI));
        double sum1 = 0.0;
        for (f = 1.0; f < (double)steps; f += 2.0) {
            t = f * h;
            sum1 += Math.exp(-X * t * t) * this.calcI(this.nx[i], this.nx[j], this.nx[k], this.nx[l], t, this.alpha[i], this.alpha[j], this.alpha[k], this.alpha[l], this.r[i].vector[0], this.r[j].vector[0], this.r[k].vector[0], this.r[l].vector[0]) * this.calcI(this.ny[i], this.ny[j], this.ny[k], this.ny[l], t, this.alpha[i], this.alpha[j], this.alpha[k], this.alpha[l], this.r[i].vector[1], this.r[j].vector[1], this.r[k].vector[1], this.r[l].vector[1]) * this.calcI(this.nz[i], this.nz[j], this.nz[k], this.nz[l], t, this.alpha[i], this.alpha[j], this.alpha[k], this.alpha[l], this.r[i].vector[2], this.r[j].vector[2], this.r[k].vector[2], this.r[l].vector[2]);
        }
        double sum2 = 0.0;
        for (f = 2.0; f < (double)steps; f += 2.0) {
            t = f * h;
            sum2 += Math.exp(-X * t * t) * this.calcI(this.nx[i], this.nx[j], this.nx[k], this.nx[l], t, this.alpha[i], this.alpha[j], this.alpha[k], this.alpha[l], this.r[i].vector[0], this.r[j].vector[0], this.r[k].vector[0], this.r[l].vector[0]) * this.calcI(this.ny[i], this.ny[j], this.ny[k], this.ny[l], t, this.alpha[i], this.alpha[j], this.alpha[k], this.alpha[l], this.r[i].vector[1], this.r[j].vector[1], this.r[k].vector[1], this.r[l].vector[1]) * this.calcI(this.nz[i], this.nz[j], this.nz[k], this.nz[l], t, this.alpha[i], this.alpha[j], this.alpha[k], this.alpha[l], this.r[i].vector[2], this.r[j].vector[2], this.r[k].vector[2], this.r[l].vector[2]);
        }
        t = 0.0;
        double f1 = Math.exp(-X * t * t) * this.calcI(this.nx[i], this.nx[j], this.nx[k], this.nx[l], t, this.alpha[i], this.alpha[j], this.alpha[k], this.alpha[l], this.r[i].vector[0], this.r[j].vector[0], this.r[k].vector[0], this.r[l].vector[0]) * this.calcI(this.ny[i], this.ny[j], this.ny[k], this.ny[l], t, this.alpha[i], this.alpha[j], this.alpha[k], this.alpha[l], this.r[i].vector[1], this.r[j].vector[1], this.r[k].vector[1], this.r[l].vector[1]) * this.calcI(this.nz[i], this.nz[j], this.nz[k], this.nz[l], t, this.alpha[i], this.alpha[j], this.alpha[k], this.alpha[l], this.r[i].vector[2], this.r[j].vector[2], this.r[k].vector[2], this.r[l].vector[2]);
        t = 1.0;
        double f2 = Math.exp(-X * t * t) * this.calcI(this.nx[i], this.nx[j], this.nx[k], this.nx[l], t, this.alpha[i], this.alpha[j], this.alpha[k], this.alpha[l], this.r[i].vector[0], this.r[j].vector[0], this.r[k].vector[0], this.r[l].vector[0]) * this.calcI(this.ny[i], this.ny[j], this.ny[k], this.ny[l], t, this.alpha[i], this.alpha[j], this.alpha[k], this.alpha[l], this.r[i].vector[1], this.r[j].vector[1], this.r[k].vector[1], this.r[l].vector[1]) * this.calcI(this.nz[i], this.nz[j], this.nz[k], this.nz[l], t, this.alpha[i], this.alpha[j], this.alpha[k], this.alpha[l], this.r[i].vector[2], this.r[j].vector[2], this.r[k].vector[2], this.r[l].vector[2]);
        return C * (h / 3.0) * (f1 + 4.0 * sum1 + 2.0 * sum2 + f2);
    }
}

