/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.ringsearch;

import java.util.Vector;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;

@TestClass(value="org.openscience.cdk.ringsearch.PathTest")
public class Path
extends Vector {
    private static final long serialVersionUID = -1086494171897189629L;

    public Path() {
    }

    public Path(IAtom atom1, IAtom atom2) {
        this.add(atom1);
        this.add(atom2);
    }

    @TestMethod(value="testJoin")
    public static Path join(Path path1, Path path2, IAtom atom) {
        Path newPath = new Path();
        Path tempPath = new Path();
        if (path1.firstElement() == atom) {
            path1.revert();
        }
        newPath.addAll(path1);
        if (path2.lastElement() == atom) {
            path2.revert();
        }
        tempPath.addAll(path2);
        tempPath.remove(atom);
        newPath.addAll(tempPath);
        return newPath;
    }

    @TestMethod(value="testGetIntersectionSize")
    public int getIntersectionSize(Path other) {
        int iSize = 0;
        for (int i = 0; i < this.size(); ++i) {
            IAtom a1 = (IAtom)this.elementAt(i);
            for (int j = 0; j < other.size(); ++j) {
                IAtom a2 = (IAtom)other.elementAt(j);
                if (a1 != a2) continue;
                ++iSize;
            }
        }
        return iSize;
    }

    private void revert() {
        Object o = null;
        int size = this.size();
        int i = size / 2;
        for (int f = 0; f < i; ++f) {
            o = this.elementAt(f);
            this.setElementAt(this.elementAt(size - f - 1), f);
            this.setElementAt(o, size - f - 1);
        }
    }

    public String toString(IAtomContainer ac) {
        String s = "Path of length " + this.size() + ": ";
        try {
            for (int f = 0; f < this.size(); ++f) {
                s = s + ac.getAtomNumber((IAtom)this.elementAt(f)) + " ";
            }
        }
        catch (Exception exc) {
            s = s + "Could not create a string representaion of this path";
        }
        return s;
    }
}

