/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.controller.edit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openscience.cdk.controller.Changed;
import org.openscience.cdk.controller.edit.AbstractEdit;
import org.openscience.cdk.controller.edit.IEdit;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IBond;

public class RemoveAtom
extends AbstractEdit
implements IEdit {
    IAtom atomToRemove;
    Collection<IAtom> connectedAtoms;
    Set<IBond> removedBonds;

    public static RemoveAtom remove(IAtom atom) {
        return new RemoveAtom(atom);
    }

    public static IEdit edit(IAtom atom) {
        return new RemoveAtom(atom);
    }

    private RemoveAtom(IAtom atom) {
        this.atomToRemove = atom;
    }

    @Override
    public void redo() {
        IAtom atom = this.atomToRemove;
        List atomsToUpdate = this.model.getConnectedAtomsList(atom);
        this.removedBonds = new HashSet<IBond>();
        this.connectedAtoms = atomsToUpdate;
        this.removedBonds.addAll(this.model.getConnectedBondsList(atom));
        this.model.removeAtomAndConnectedElectronContainers(atom);
        this.updateHydrogenCount(atomsToUpdate);
    }

    @Override
    public void undo() {
        this.model.addAtom(this.atomToRemove);
        for (IBond bond : this.removedBonds) {
            this.model.addBond(bond);
        }
        ArrayList<IAtom> atomsToUpdate = new ArrayList<IAtom>(this.connectedAtoms);
        atomsToUpdate.add(this.atomToRemove);
        this.updateHydrogenCount(atomsToUpdate);
    }

    @Override
    public Set<Changed> getTypeOfChanges() {
        return RemoveAtom.changed(Changed.Structure);
    }
}

