/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.reaction.type;

import java.util.ArrayList;
import org.openscience.cdk.DefaultChemObjectBuilder;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IMolecule;
import org.openscience.cdk.interfaces.IMoleculeSet;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.interfaces.IReactionSet;
import org.openscience.cdk.reaction.IReactionProcess;
import org.openscience.cdk.reaction.ReactionEngine;
import org.openscience.cdk.reaction.ReactionSpecification;
import org.openscience.cdk.reaction.type.parameters.IParameterReact;
import org.openscience.cdk.reaction.type.parameters.SetReactionCenter;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

@TestClass(value="org.openscience.cdk.reaction.type.AdductionProtonPBReactionTest")
public class AdductionProtonPBReaction
extends ReactionEngine
implements IReactionProcess {
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(AdductionProtonPBReaction.class);

    @Override
    @TestMethod(value="testGetSpecification")
    public ReactionSpecification getSpecification() {
        return new ReactionSpecification("http://almost.cubic.uni-koeln.de/jrg/Members/mrc/reactionDict/reactionDict#AdductionProtonPB", this.getClass().getName(), "$Id$", "The Chemistry Development Kit");
    }

    @Override
    @TestMethod(value="testInitiate_IMoleculeSet_IMoleculeSet")
    public IReactionSet initiate(IMoleculeSet reactants, IMoleculeSet agents) throws CDKException {
        logger.debug("initiate reaction: AdductionProtonPBReaction");
        if (reactants.getMoleculeCount() != 1) {
            throw new CDKException("AdductionProtonPBReaction only expects one reactant");
        }
        if (agents != null) {
            throw new CDKException("AdductionProtonPBReaction don't expects agents");
        }
        IReactionSet setOfReactions = DefaultChemObjectBuilder.getInstance().newInstance(IReactionSet.class, new Object[0]);
        IMolecule reactant = reactants.getMolecule(0);
        IParameterReact ipr = super.getParameterClass(SetReactionCenter.class);
        if (ipr != null && !ipr.isSetParameter()) {
            this.setActiveCenters(reactant);
        }
        if (AtomContainerManipulator.getTotalCharge(reactant) != 0.0) {
            return setOfReactions;
        }
        for (IBond bondi : reactant.bonds()) {
            int chargeAtom1;
            if (!bondi.getFlag(10) || bondi.getOrder() != IBond.Order.DOUBLE && bondi.getOrder() != IBond.Order.TRIPLE || !bondi.getAtom(0).getFlag(10) || !bondi.getAtom(1).getFlag(10)) continue;
            int chargeAtom0 = bondi.getAtom(0).getFormalCharge() == null ? 0 : bondi.getAtom(0).getFormalCharge();
            int n = chargeAtom1 = bondi.getAtom(1).getFormalCharge() == null ? 0 : bondi.getAtom(1).getFormalCharge();
            if (chargeAtom0 < 0 || chargeAtom1 < 0 || reactant.getConnectedSingleElectronsCount(bondi.getAtom(0)) != 0 || reactant.getConnectedSingleElectronsCount(bondi.getAtom(1)) != 0 || reactant.getConnectedLonePairsCount(bondi.getAtom(0)) != 0 || reactant.getConnectedLonePairsCount(bondi.getAtom(1)) != 0) continue;
            for (int j = 0; j < 2; ++j) {
                ArrayList<IAtom> atomList = new ArrayList<IAtom>();
                if (j == 0) {
                    atomList.add(bondi.getAtom(0));
                    atomList.add(bondi.getAtom(1));
                } else {
                    atomList.add(bondi.getAtom(1));
                    atomList.add(bondi.getAtom(0));
                }
                IAtom atomH = reactant.getBuilder().newInstance(IAtom.class, "H");
                atomH.setFormalCharge(1);
                atomList.add(atomH);
                ArrayList<IBond> bondList = new ArrayList<IBond>();
                bondList.add(bondi);
                IMoleculeSet moleculeSet = reactant.getBuilder().newInstance(IMoleculeSet.class, new Object[0]);
                moleculeSet.addMolecule(reactant);
                IMolecule adduct = reactant.getBuilder().newInstance(IMolecule.class, new Object[0]);
                adduct.addAtom(atomH);
                moleculeSet.addMolecule(adduct);
                IReaction reaction = this.mechanism.initiate(moleculeSet, atomList, bondList);
                if (reaction == null) continue;
                setOfReactions.addReaction(reaction);
            }
        }
        return setOfReactions;
    }

    private void setActiveCenters(IMolecule reactant) throws CDKException {
        if (AtomContainerManipulator.getTotalCharge(reactant) != 0.0) {
            return;
        }
        for (IBond bondi : reactant.bonds()) {
            int chargeAtom1;
            if (bondi.getOrder() != IBond.Order.DOUBLE && bondi.getOrder() != IBond.Order.TRIPLE) continue;
            int chargeAtom0 = bondi.getAtom(0).getFormalCharge() == null ? 0 : bondi.getAtom(0).getFormalCharge();
            int n = chargeAtom1 = bondi.getAtom(1).getFormalCharge() == null ? 0 : bondi.getAtom(1).getFormalCharge();
            if (chargeAtom0 < 0 || chargeAtom1 < 0 || reactant.getConnectedSingleElectronsCount(bondi.getAtom(0)) != 0 || reactant.getConnectedSingleElectronsCount(bondi.getAtom(1)) != 0 || reactant.getConnectedLonePairsCount(bondi.getAtom(0)) != 0 || reactant.getConnectedLonePairsCount(bondi.getAtom(1)) != 0) continue;
            bondi.setFlag(10, true);
            bondi.getAtom(0).setFlag(10, true);
            bondi.getAtom(1).setFlag(10, true);
        }
    }
}

