/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.color;

import java.awt.Color;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.renderer.color.IAtomColorer;

public class CDKAtomColors
implements IAtomColorer {
    private static final Color HYDROGEN = Color.white;
    private static final Color CARBON = Color.black;
    private static final Color NITROGEN = Color.blue;
    private static final Color OXYGEN = Color.red;
    private static final Color PHOSPHORUS = Color.green;
    private static final Color SULPHUR = Color.yellow;
    private static final Color CHLORINE = Color.magenta;
    private static final Color DEFAULT = Color.darkGray;

    @Override
    public Color getAtomColor(IAtom atom) {
        return this.getAtomColor(atom, DEFAULT);
    }

    @Override
    public Color getAtomColor(IAtom atom, Color defaultColor) {
        Color color = defaultColor;
        int atomnumber = atom.getAtomicNumber();
        switch (atomnumber) {
            case 1: {
                color = HYDROGEN;
                break;
            }
            case 6: {
                color = CARBON;
                break;
            }
            case 7: {
                color = NITROGEN;
                break;
            }
            case 8: {
                color = OXYGEN;
                break;
            }
            case 15: {
                color = PHOSPHORUS;
                break;
            }
            case 16: {
                color = SULPHUR;
                break;
            }
            case 17: {
                color = CHLORINE;
            }
        }
        return color;
    }
}

