/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.smsd.algorithm.mcgregor;

import java.util.Collections;
import java.util.List;
import org.openscience.cdk.annotations.TestClass;

@TestClass(value="org.openscience.cdk.smsd.algorithm.mcgregor.McgregorHelperTest")
public class McgregorHelper {
    private final List<String> c_bond_setA;
    private final List<String> c_bond_setB;
    private final boolean mappingCheckFlag;
    private final int mappedAtomCount;
    private final List<Integer> mappedAtomsOrg;
    private final int neighborBondNumA;
    private final int neighborBondNumB;
    private final List<Integer> iBondNeighborAtomsA;
    private final List<Integer> iBondNeighborAtomsB;
    private final List<String> cBondNeighborsA;
    private final List<String> cBondNeighborsB;
    private final int setNumA;
    private final int setNumB;
    private final List<Integer> i_bond_setA;
    private final List<Integer> i_bond_setB;

    protected McgregorHelper(boolean mappingCheckFlag, int mappedAtomCount, List<Integer> mappedAtomsOrg, int neighborBondNumA, int neighborBondNumB, List<Integer> iBondNeighborAtomsA, List<Integer> iBondNeighborAtomsB, List<String> cBondNeighborsA, List<String> cBondNeighborsB, int setNumA, int setNumB, List<Integer> i_bond_setA, List<Integer> i_bond_setB, List<String> c_bond_setA, List<String> c_bond_setB) {
        this.c_bond_setA = c_bond_setA;
        this.c_bond_setB = c_bond_setB;
        this.mappingCheckFlag = mappingCheckFlag;
        this.mappedAtomCount = mappedAtomCount;
        this.mappedAtomsOrg = mappedAtomsOrg;
        this.neighborBondNumA = neighborBondNumA;
        this.neighborBondNumB = neighborBondNumB;
        this.iBondNeighborAtomsA = iBondNeighborAtomsA;
        this.iBondNeighborAtomsB = iBondNeighborAtomsB;
        this.cBondNeighborsA = cBondNeighborsA;
        this.cBondNeighborsB = cBondNeighborsB;
        this.setNumA = setNumA;
        this.setNumB = setNumB;
        this.i_bond_setA = i_bond_setA;
        this.i_bond_setB = i_bond_setB;
    }

    protected List<String> getCBondSetA() {
        return Collections.unmodifiableList(this.c_bond_setA);
    }

    protected List<String> getCBondSetB() {
        return Collections.unmodifiableList(this.c_bond_setB);
    }

    protected boolean isMappingCheckFlag() {
        return this.mappingCheckFlag;
    }

    protected int getMappedAtomCount() {
        return this.mappedAtomCount;
    }

    protected List<Integer> getMappedAtomsOrg() {
        return Collections.unmodifiableList(this.mappedAtomsOrg);
    }

    protected int getNeighborBondNumA() {
        return this.neighborBondNumA;
    }

    protected int getNeighborBondNumB() {
        return this.neighborBondNumB;
    }

    protected List<Integer> getiBondNeighborAtomsA() {
        return Collections.unmodifiableList(this.iBondNeighborAtomsA);
    }

    protected List<Integer> getiBondNeighborAtomsB() {
        return Collections.unmodifiableList(this.iBondNeighborAtomsB);
    }

    protected List<String> getcBondNeighborsA() {
        return Collections.unmodifiableList(this.cBondNeighborsA);
    }

    protected List<String> getcBondNeighborsB() {
        return Collections.unmodifiableList(this.cBondNeighborsB);
    }

    protected int getSetNumA() {
        return this.setNumA;
    }

    protected List<Integer> getIBondSetA() {
        return Collections.unmodifiableList(this.i_bond_setA);
    }

    protected List<Integer> getIBondSetB() {
        return Collections.unmodifiableList(this.i_bond_setB);
    }

    int getsetNumB() {
        return this.setNumB;
    }
}

