/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.controller.undoredo;

import org.openscience.cdk.controller.undoredo.IUndoRedoable;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IMoleculeSet;
import org.openscience.cdk.interfaces.IReactionSet;

public class ClearAllEdit
implements IUndoRedoable {
    private static final long serialVersionUID = -9022673628051651034L;
    private IChemModel chemModel;
    private IMoleculeSet som;
    private IReactionSet sor;
    private String type;

    public ClearAllEdit(IChemModel chemModel, IMoleculeSet som, IReactionSet sor, String type) {
        this.chemModel = chemModel;
        this.som = som;
        this.sor = sor;
        this.type = type;
    }

    @Override
    public void redo() {
        if (this.chemModel.getMoleculeSet() != null) {
            this.chemModel.getMoleculeSet().removeAllAtomContainers();
        }
        if (this.chemModel.getReactionSet() != null) {
            this.chemModel.getReactionSet().removeAllReactions();
        }
    }

    @Override
    public void undo() {
        if (this.som != null) {
            this.chemModel.setMoleculeSet(this.som);
        }
        if (this.sor != null) {
            this.chemModel.setReactionSet(this.sor);
        }
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    public String getPresentationName() {
        return this.type;
    }
}

