/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.graph.invariant;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.smiles.InvPair;
import org.openscience.cdk.tools.periodictable.PeriodicTable;

@TestClass(value="org.openscience.cdk.graph.invariant.CanonicalLabelerTest")
public class CanonicalLabeler {
    @TestMethod(value="testCanonLabel_IAtomContainer,testSomeMoleculeWithDifferentStartingOrder")
    public synchronized void canonLabel(IAtomContainer atomContainer) {
        if (atomContainer.getAtomCount() == 0) {
            return;
        }
        if (atomContainer.getAtomCount() == 1) {
            atomContainer.getAtom(0).setProperty("CanonicalLabel", 1);
        }
        ArrayList vect = this.createInvarLabel(atomContainer);
        this.step3(vect, atomContainer);
    }

    private void step2(ArrayList v, IAtomContainer atoms) {
        this.primeProduct(v, atoms);
        this.step3(v, atoms);
    }

    private void step3(ArrayList v, IAtomContainer atoms) {
        this.sortArrayList(v);
        this.rankArrayList(v);
        if (!this.isInvPart(v)) {
            this.step2(v, atoms);
        } else {
            if (((InvPair)v.get(v.size() - 1)).getCurr() < (long)v.size()) {
                this.breakTies(v);
                this.step2(v, atoms);
            }
            for (Object aV : v) {
                ((InvPair)aV).commit();
            }
        }
    }

    private ArrayList createInvarLabel(IAtomContainer atomContainer) {
        Iterator<IAtom> atoms = atomContainer.atoms().iterator();
        ArrayList<InvPair> vect = new ArrayList<InvPair>();
        while (atoms.hasNext()) {
            IAtom a = atoms.next();
            StringBuffer inv = new StringBuffer();
            inv.append(atomContainer.getConnectedAtomsList(a).size() + (a.getImplicitHydrogenCount() == CDKConstants.UNSET ? 0 : a.getImplicitHydrogenCount()));
            inv.append(atomContainer.getConnectedAtomsList(a).size());
            inv.append(PeriodicTable.getAtomicNumber(a.getSymbol()));
            Double charge = a.getCharge();
            if (charge == CDKConstants.UNSET) {
                charge = 0.0;
            }
            if (charge < 0.0) {
                inv.append(1);
            } else {
                inv.append(0);
            }
            inv.append((int)Math.abs(a.getFormalCharge() == CDKConstants.UNSET ? 0.0 : (double)a.getFormalCharge().intValue()));
            inv.append(a.getImplicitHydrogenCount() == CDKConstants.UNSET ? 0 : a.getImplicitHydrogenCount());
            vect.add(new InvPair(Long.parseLong(inv.toString()), a));
        }
        return vect;
    }

    private void primeProduct(ArrayList v, IAtomContainer atomContainer) {
        for (InvPair inv : v) {
            List<IAtom> neighbour = atomContainer.getConnectedAtomsList(inv.getAtom());
            Iterator<IAtom> n = neighbour.iterator();
            long summ = 1L;
            while (n.hasNext()) {
                IAtom a = n.next();
                int next = ((InvPair)a.getProperty("InvariancePair")).getPrime();
                summ *= (long)next;
            }
            inv.setLast(inv.getCurr());
            inv.setCurr(summ);
        }
    }

    private void sortArrayList(ArrayList v) {
        Collections.sort(v, new Comparator(){

            public int compare(Object o1, Object o2) {
                return (int)(((InvPair)o1).getCurr() - ((InvPair)o2).getCurr());
            }
        });
        Collections.sort(v, new Comparator(){

            public int compare(Object o1, Object o2) {
                return (int)(((InvPair)o1).getLast() - ((InvPair)o2).getLast());
            }
        });
    }

    private void rankArrayList(ArrayList v) {
        InvPair curr;
        int num = 1;
        int[] temp = new int[v.size()];
        InvPair last = (InvPair)v.get(0);
        Iterator it = v.iterator();
        int x = 0;
        while (it.hasNext()) {
            curr = (InvPair)it.next();
            if (!last.equals(curr)) {
                // empty if block
            }
            temp[x] = ++num;
            last = curr;
            ++x;
        }
        it = v.iterator();
        x = 0;
        while (it.hasNext()) {
            curr = (InvPair)it.next();
            curr.setCurr(temp[x]);
            curr.setPrime();
            ++x;
        }
    }

    private boolean isInvPart(ArrayList v) {
        if (((InvPair)v.get(v.size() - 1)).getCurr() == (long)v.size()) {
            return true;
        }
        for (InvPair curr : v) {
            if (curr.getCurr() == curr.getLast()) continue;
            return false;
        }
        return true;
    }

    private void breakTies(ArrayList v) {
        InvPair curr;
        Iterator it = v.iterator();
        InvPair last = null;
        int tie = 0;
        boolean found = false;
        int x = 0;
        while (it.hasNext()) {
            curr = (InvPair)it.next();
            curr.setCurr(curr.getCurr() * 2L);
            curr.setPrime();
            if (x != 0 && !found && curr.getCurr() == last.getCurr()) {
                tie = x - 1;
                found = true;
            }
            last = curr;
            ++x;
        }
        curr = (InvPair)v.get(tie);
        curr.setCurr(curr.getCurr() - 1L);
        curr.setPrime();
    }
}

