/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io.iterator;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.NoSuchElementException;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IMolecule;
import org.openscience.cdk.io.ISimpleChemObjectReader;
import org.openscience.cdk.io.MDLV2000Reader;
import org.openscience.cdk.io.ReaderFactory;
import org.openscience.cdk.io.formats.IChemFormat;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.formats.MDLFormat;
import org.openscience.cdk.io.formats.MDLV2000Format;
import org.openscience.cdk.io.formats.MDLV3000Format;
import org.openscience.cdk.io.iterator.DefaultIteratingChemObjectReader;
import org.openscience.cdk.io.listener.IChemObjectIOListener;
import org.openscience.cdk.io.setting.BooleanIOSetting;
import org.openscience.cdk.io.setting.IOSetting;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class IteratingMDLReader
extends DefaultIteratingChemObjectReader
implements IChemObjectIOListener {
    private BufferedReader input;
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(IteratingMDLReader.class);
    private String currentLine;
    private IChemFormat currentFormat;
    private final ReaderFactory factory = new ReaderFactory();
    private boolean nextAvailableIsKnown;
    private boolean hasNext;
    private IChemObjectBuilder builder;
    private IMolecule nextMolecule;
    private BooleanIOSetting forceReadAs3DCoords;

    public IteratingMDLReader(Reader in, IChemObjectBuilder builder) {
        this.builder = builder;
        this.setReader(in);
        this.initIOSettings();
    }

    public IteratingMDLReader(InputStream in, IChemObjectBuilder builder) {
        this(new InputStreamReader(in), builder);
    }

    @TestMethod(value="testGetFormat")
    public IResourceFormat getFormat() {
        return this.currentFormat;
    }

    public boolean hasNext() {
        if (!this.nextAvailableIsKnown) {
            this.hasNext = false;
            try {
                this.currentLine = this.input.readLine();
                if (this.currentLine != null) {
                    this.currentFormat = (IChemFormat)MDLFormat.getInstance();
                    StringBuffer buffer = new StringBuffer();
                    while (this.currentLine != null && !this.currentLine.equals("M  END")) {
                        buffer.append(this.currentLine);
                        buffer.append(System.getProperty("line.separator"));
                        this.currentLine = this.input.readLine();
                        if (this.currentLine.contains("V2000") || this.currentLine.contains("v2000")) {
                            this.currentFormat = (IChemFormat)MDLV2000Format.getInstance();
                            continue;
                        }
                        if (!this.currentLine.contains("V3000") && !this.currentLine.contains("v3000")) continue;
                        this.currentFormat = (IChemFormat)MDLV3000Format.getInstance();
                    }
                    buffer.append(this.currentLine);
                    buffer.append(System.getProperty("line.separator"));
                    logger.debug("MDL file part read: ", buffer);
                    ISimpleChemObjectReader reader = this.factory.createReader(this.currentFormat);
                    reader.setReader(new StringReader(buffer.toString()));
                    reader.setErrorHandler(this.errorHandler);
                    reader.setReaderMode(this.mode);
                    if (this.currentFormat instanceof MDLV2000Format) {
                        reader.addChemObjectIOListener(this);
                        ((MDLV2000Reader)reader).customizeJob();
                    }
                    this.nextMolecule = (IMolecule)reader.read((IChemObject)this.builder.newInstance(IMolecule.class, new Object[0]));
                    this.hasNext = this.nextMolecule != null;
                    this.currentLine = this.input.readLine();
                    this.readDataBlockInto(this.nextMolecule);
                } else {
                    this.hasNext = false;
                }
            }
            catch (Exception exception) {
                logger.error("Error while reading next molecule: " + exception.getMessage());
                logger.debug(exception);
                this.hasNext = false;
            }
            if (!this.hasNext) {
                this.nextMolecule = null;
            }
            this.nextAvailableIsKnown = true;
        }
        return this.hasNext;
    }

    private void readDataBlockInto(IMolecule m) throws IOException {
        String fieldName = null;
        while (this.currentLine != null && !this.currentLine.trim().equals("$$$$")) {
            logger.debug("looking for data header: ", this.currentLine);
            String str = new String(this.currentLine);
            if (str.startsWith("> ")) {
                fieldName = this.extractFieldName(fieldName, str);
                str = this.skipOtherFieldHeaderLines(str);
                String data = this.extractFieldData(str);
                if (fieldName != null) {
                    logger.info("fieldName, data: ", fieldName, ", ", data);
                    m.setProperty(fieldName, data);
                }
            }
            this.currentLine = this.input.readLine();
        }
    }

    private String extractFieldData(String str) throws IOException {
        StringBuilder data = new StringBuilder();
        while (str.trim().length() > 0) {
            logger.debug("data line: ", this.currentLine);
            data.append(str);
            this.currentLine = this.input.readLine();
            str = new String(this.currentLine).trim();
        }
        return data.toString();
    }

    private String skipOtherFieldHeaderLines(String str) throws IOException {
        while (str.startsWith("> ")) {
            logger.debug("data header line: ", this.currentLine);
            this.currentLine = this.input.readLine();
            str = new String(this.currentLine);
        }
        return str;
    }

    private String extractFieldName(String fieldName, String str) {
        int index2;
        int index = str.indexOf("<");
        if (index != -1 && (index2 = str.substring(index).indexOf(">")) != -1) {
            fieldName = str.substring(index + 1, index + index2);
        }
        return fieldName;
    }

    public IChemObject next() {
        if (!this.nextAvailableIsKnown) {
            this.hasNext();
        }
        this.nextAvailableIsKnown = false;
        if (!this.hasNext) {
            throw new NoSuchElementException();
        }
        return this.nextMolecule;
    }

    @TestMethod(value="testClose")
    public void close() throws IOException {
        this.input.close();
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    @TestMethod(value="testSetReader_Reader")
    public void setReader(Reader reader) {
        this.input = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        this.nextMolecule = null;
        this.nextAvailableIsKnown = false;
        this.hasNext = false;
    }

    @TestMethod(value="testSetReader_InputStream")
    public void setReader(InputStream reader) {
        this.setReader(new InputStreamReader(reader));
    }

    private void initIOSettings() {
        this.forceReadAs3DCoords = new BooleanIOSetting("ForceReadAs3DCoordinates", 2, "Should coordinates always be read as 3D?", "false");
    }

    public void customizeJob() {
        this.fireIOSettingQuestion(this.forceReadAs3DCoords);
    }

    public IOSetting[] getIOSettings() {
        IOSetting[] settings = new IOSetting[]{this.forceReadAs3DCoords};
        return settings;
    }

    public void processIOSettingQuestion(IOSetting setting) {
        if (setting.getName().equals(this.forceReadAs3DCoords.getName())) {
            try {
                setting.setSetting(this.forceReadAs3DCoords.getSetting());
            }
            catch (CDKException e) {
                logger.debug("Could not propagate forceReadAs3DCoords setting");
            }
        }
    }
}

