/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar;

import java.util.HashMap;
import java.util.Map;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.qsar.IAtomicDescriptor;
import org.openscience.cdk.qsar.result.IDescriptorResult;

public abstract class AbstractAtomicDescriptor
implements IAtomicDescriptor {
    private static final String PREVIOUS_ATOMCONTAINER = "previousAtomContainer";
    private Map cachedDescriptorValues = null;

    public boolean isCachedAtomContainer(IAtomContainer container) {
        if (this.cachedDescriptorValues == null) {
            return false;
        }
        return this.cachedDescriptorValues.get(PREVIOUS_ATOMCONTAINER) == container;
    }

    public IDescriptorResult getCachedDescriptorValue(IAtom atom) {
        if (this.cachedDescriptorValues == null) {
            return null;
        }
        return (IDescriptorResult)this.cachedDescriptorValues.get(atom);
    }

    public void cacheDescriptorValue(IAtom atom, IAtomContainer container, IDescriptorResult value) {
        if (this.cachedDescriptorValues == null) {
            this.cachedDescriptorValues = new HashMap();
            this.cachedDescriptorValues.put(PREVIOUS_ATOMCONTAINER, container);
        } else if (this.cachedDescriptorValues.get(PREVIOUS_ATOMCONTAINER) != container) {
            this.cachedDescriptorValues.clear();
            this.cachedDescriptorValues.put(PREVIOUS_ATOMCONTAINER, container);
        }
        this.cachedDescriptorValues.put(atom, value);
    }
}

