/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.molecular;

import org.openscience.cdk.Molecule;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.charges.GasteigerMarsiliPartialCharges;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.matrix.TopologicalMatrix;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.DoubleArrayResult;
import org.openscience.cdk.qsar.result.DoubleArrayResultType;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

@TestClass(value="org.openscience.cdk.qsar.descriptors.molecular.AutocorrelationDescriptorChargeTest")
public class AutocorrelationDescriptorCharge
implements IMolecularDescriptor {
    private static final String[] names = new String[]{"ATSc1", "ATSc2", "ATSc3", "ATSc4", "ATSc5"};

    private static double[] listcharges(IAtomContainer container) throws CDKException {
        int natom = container.getAtomCount();
        double[] charges = new double[natom];
        try {
            Molecule mol = new Molecule((IAtomContainer)container.clone());
            GasteigerMarsiliPartialCharges peoe = new GasteigerMarsiliPartialCharges();
            peoe.assignGasteigerMarsiliSigmaPartialCharges(mol, true);
            for (int i = 0; i < natom; ++i) {
                IAtom atom = mol.getAtom(i);
                charges[i] = atom.getCharge();
            }
        }
        catch (Exception ex1) {
            throw new CDKException("Problems with assignGasteigerMarsiliPartialCharges due to " + ex1.toString(), ex1);
        }
        return charges;
    }

    @TestMethod(value="test1")
    public DescriptorValue calculate(IAtomContainer atomContainer) {
        IAtomContainer container;
        try {
            container = (IAtomContainer)atomContainer.clone();
            container = AtomContainerManipulator.removeHydrogens(container);
        }
        catch (CloneNotSupportedException e) {
            DoubleArrayResult result = new DoubleArrayResult(5);
            for (int i = 0; i < 5; ++i) {
                result.add(Double.NaN);
            }
            return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), result, this.getDescriptorNames(), new CDKException("Error during cloner: " + e.getMessage(), e));
        }
        try {
            double[] w = AutocorrelationDescriptorCharge.listcharges(container);
            int natom = container.getAtomCount();
            int[][] distancematrix = TopologicalMatrix.getMatrix(container);
            double[] chargeSum = new double[5];
            for (int k = 0; k < 5; ++k) {
                for (int i = 0; i < natom; ++i) {
                    for (int j = 0; j < natom; ++j) {
                        if (distancematrix[i][j] == k) {
                            int n = k;
                            chargeSum[n] = chargeSum[n] + w[i] * w[j];
                            continue;
                        }
                        int n = k;
                        chargeSum[n] = chargeSum[n] + 0.0;
                    }
                }
                if (k <= 0) continue;
                chargeSum[k] = chargeSum[k] / 2.0;
            }
            DoubleArrayResult result = new DoubleArrayResult(5);
            for (double aChargeSum : chargeSum) {
                result.add(aChargeSum);
            }
            return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), result, names);
        }
        catch (Exception ex) {
            DoubleArrayResult result = new DoubleArrayResult(5);
            for (int i = 0; i < 5; ++i) {
                result.add(Double.NaN);
            }
            return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), result, names, new CDKException("Error while calculating the ATS_charge descriptor: " + ex.getMessage(), ex));
        }
    }

    @TestMethod(value="testGetParameterNames")
    public String[] getParameterNames() {
        return new String[0];
    }

    @TestMethod(value="testGetParameterType_String")
    public Object getParameterType(String name) {
        return null;
    }

    @TestMethod(value="testGetParameters")
    public Object[] getParameters() {
        return null;
    }

    @TestMethod(value="testNamesConsistency")
    public String[] getDescriptorNames() {
        return names;
    }

    @TestMethod(value="testGetSpecification")
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#autoCorrelationCharge", this.getClass().getName(), "$Id$", "The Chemistry Development Kit");
    }

    @TestMethod(value="testGetDescriptorResultType")
    public IDescriptorResult getDescriptorResultType() {
        return new DoubleArrayResultType(5);
    }

    @TestMethod(value="testSetParameters_arrayObject")
    public void setParameters(Object[] params) throws CDKException {
    }
}

