/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.ringsearch;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.ConnectivityChecker;
import org.openscience.cdk.graph.SpanningTree;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IMolecule;
import org.openscience.cdk.interfaces.IRing;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.ringsearch.Path;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TestClass(value="org.openscience.cdk.ringsearch.AllRingsFinderTest")
public class AllRingsFinder {
    private ILoggingTool logger = null;
    public boolean debug = false;
    private long timeout = 5000L;
    private long startTime;
    IAtomContainer originalAc = null;
    List<Path> newPaths = new ArrayList<Path>();
    List<Path> potentialRings = new ArrayList<Path>();
    List<Path> removePaths = new ArrayList<Path>();

    public AllRingsFinder(boolean logging) {
        if (logging) {
            this.logger = LoggingToolFactory.createLoggingTool(AllRingsFinder.class);
        }
    }

    public AllRingsFinder() {
        this(true);
    }

    @TestMethod(value="testFindAllRings_IAtomContainer,testBondsWithinRing")
    public IRingSet findAllRings(IAtomContainer atomContainer) throws CDKException {
        return this.findAllRings(atomContainer, null);
    }

    public IRingSet findAllRings(IAtomContainer atomContainer, Integer maxRingSize) throws CDKException {
        this.startTime = System.currentTimeMillis();
        SpanningTree spanningTree = new SpanningTree(atomContainer);
        IAtomContainer ringSystems = spanningTree.getCyclicFragmentsContainer();
        Iterator<IAtomContainer> separateRingSystem = ConnectivityChecker.partitionIntoMolecules(ringSystems).molecules().iterator();
        IRingSet resultSet = atomContainer.getBuilder().newInstance(IRingSet.class, new Object[0]);
        while (separateRingSystem.hasNext()) {
            resultSet.add(this.findAllRingsInIsolatedRingSystem((IMolecule)separateRingSystem.next(), maxRingSize));
        }
        return resultSet;
    }

    public IRingSet findAllRingsInIsolatedRingSystem(IAtomContainer atomContainer) throws CDKException {
        return this.findAllRingsInIsolatedRingSystem(atomContainer, null);
    }

    public IRingSet findAllRingsInIsolatedRingSystem(IAtomContainer atomContainer, Integer maxRingSize) throws CDKException {
        if (this.startTime == 0L) {
            this.startTime = System.currentTimeMillis();
        }
        ArrayList<Path> paths = new ArrayList<Path>();
        IRingSet ringSet = atomContainer.getBuilder().newInstance(IRingSet.class, new Object[0]);
        IAtomContainer ac = atomContainer.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        this.originalAc = atomContainer;
        ac.add(atomContainer);
        this.doSearch(ac, paths, ringSet, maxRingSize);
        return ringSet;
    }

    private void doSearch(IAtomContainer ac, List<Path> paths, IRingSet ringSet, Integer maxPathLen) throws CDKException {
        IAtom atom;
        this.initPathGraph(ac, paths);
        if (this.logger != null) {
            this.logger.debug("BondCount: ", ac.getBondCount());
            this.logger.debug("PathCount: ", paths.size());
        }
        do {
            if ((atom = this.selectAtom(ac)) == null) continue;
            this.remove(atom, ac, paths, ringSet, maxPathLen);
        } while (paths.size() > 0 && atom != null);
        if (this.logger != null) {
            this.logger.debug("paths.size(): ", paths.size());
            this.logger.debug("ringSet.size(): ", ringSet.getAtomContainerCount());
        }
    }

    private void remove(IAtom atom, IAtomContainer ac, List<Path> paths, IRingSet rings, Integer maxPathLen) throws CDKException {
        this.newPaths.clear();
        this.removePaths.clear();
        this.potentialRings.clear();
        if (this.logger != null) {
            this.logger.debug("*** Removing atom " + this.originalAc.getAtomNumber(atom) + " ***");
        }
        for (int i = 0; i < paths.size(); ++i) {
            Path path1 = paths.get(i);
            if (path1.firstElement() != atom && path1.lastElement() != atom) continue;
            for (int j = i + 1; j < paths.size(); ++j) {
                int intersectionSize;
                Path path2 = paths.get(j);
                if ((path2.firstElement() == atom || path2.lastElement() == atom) && (intersectionSize = path1.getIntersectionSize(path2)) < 3) {
                    if (this.logger != null) {
                        this.logger.debug("Joining " + path1.toString(this.originalAc) + " and " + path2.toString(this.originalAc));
                    }
                    Path union = Path.join(path1, path2, atom);
                    if (intersectionSize == 1) {
                        this.newPaths.add(union);
                    } else if (maxPathLen == null || union.size() <= maxPathLen + 1) {
                        this.potentialRings.add(union);
                    }
                    if (this.logger != null) {
                        this.logger.debug("Union: ", union.toString(this.originalAc));
                    }
                    this.removePaths.add(path1);
                    this.removePaths.add(path2);
                }
                if (this.timeout <= 0L) continue;
                this.checkTimeout();
            }
        }
        for (Path removePath : this.removePaths) {
            paths.remove(removePath);
        }
        for (Path newPath : this.newPaths) {
            if (maxPathLen != null && newPath.size() > maxPathLen + 1) continue;
            paths.add(newPath);
        }
        this.detectRings(this.potentialRings, rings, this.originalAc);
        ac.removeAtomAndConnectedElectronContainers(atom);
        if (this.logger != null) {
            this.logger.debug("\n" + paths.size() + " paths and " + ac.getAtomCount() + " atoms left.");
        }
    }

    private void detectRings(List<Path> paths, IRingSet ringSet, IAtomContainer ac) {
        IAtom a2 = null;
        for (Path path : paths) {
            int bondNum;
            IAtom a1;
            if (path.size() <= 3 || path.lastElement() != path.firstElement()) continue;
            if (this.logger != null) {
                this.logger.debug("Removing path " + path.toString(this.originalAc) + " which is a ring.");
            }
            path.removeElementAt(0);
            IRing ring = ac.getBuilder().newInstance(IRing.class, new Object[0]);
            for (int g = 0; g < path.size() - 1; ++g) {
                a1 = (IAtom)path.elementAt(g);
                a2 = (IAtom)path.elementAt(g + 1);
                ring.addAtom(a1);
                bondNum = ac.getBondNumber(a1, a2);
                ring.addBond(ac.getBond(bondNum));
            }
            ring.addAtom(a2);
            a1 = (IAtom)path.elementAt(0);
            a2 = (IAtom)path.elementAt(path.size() - 1);
            ring.addAtom(a1);
            bondNum = ac.getBondNumber(a1, a2);
            ring.addBond(ac.getBond(bondNum));
            ringSet.addAtomContainer(ring);
        }
    }

    private void initPathGraph(IAtomContainer ac, List<Path> paths) {
        for (IBond bond : ac.bonds()) {
            Path path = new Path(bond.getAtom(0), bond.getAtom(1));
            paths.add(path);
            if (this.logger == null) continue;
            this.logger.debug("initPathGraph: " + path.toString(this.originalAc));
        }
    }

    private IAtom selectAtom(IAtomContainer ac) {
        int minDegree = 999;
        IAtom minAtom = null;
        for (int f = 0; f < ac.getAtomCount(); ++f) {
            IAtom atom = ac.getAtom(f);
            int degree = ac.getConnectedBondsCount(atom);
            if (degree >= minDegree) continue;
            minAtom = atom;
            minDegree = degree;
        }
        return minAtom;
    }

    @TestMethod(value="testCheckTimeout")
    public void checkTimeout() throws CDKException {
        if (this.startTime == 0L) {
            return;
        }
        long time = System.currentTimeMillis();
        if (time - this.startTime > this.timeout) {
            throw new CDKException("Timeout for AllringsFinder exceeded");
        }
    }

    @TestMethod(value="testSetTimeout_long")
    public AllRingsFinder setTimeout(long timeout) {
        this.timeout = timeout;
        return this;
    }

    @TestMethod(value="testGetTimeout")
    public long getTimeout() {
        return this.timeout;
    }
}

