/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.stereo;

import org.openscience.cdk.DefaultChemObjectBuilder;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.ITetrahedralChirality;

public class TetrahedralChirality
implements ITetrahedralChirality {
    private IAtom chiralAtom;
    private IAtom[] ligandAtoms;
    private ITetrahedralChirality.Stereo stereo;

    public TetrahedralChirality(IAtom chiralAtom, IAtom[] ligandAtoms, ITetrahedralChirality.Stereo chirality) {
        this.chiralAtom = chiralAtom;
        this.ligandAtoms = ligandAtoms;
        this.stereo = chirality;
    }

    public IAtom[] getLigands() {
        IAtom[] arrayCopy = new IAtom[4];
        System.arraycopy(this.ligandAtoms, 0, arrayCopy, 0, 4);
        return arrayCopy;
    }

    public IAtom getChiralAtom() {
        return this.chiralAtom;
    }

    public ITetrahedralChirality.Stereo getStereo() {
        return this.stereo;
    }

    public IChemObjectBuilder getBuilder() {
        return DefaultChemObjectBuilder.getInstance();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Tetrahedral{").append(this.hashCode()).append(", ");
        builder.append((Object)this.getStereo()).append(", ");
        builder.append("c:").append(this.getChiralAtom()).append(", ");
        IAtom[] ligands = this.getLigands();
        for (int i = 0; i < ligands.length; ++i) {
            builder.append(i + 1).append(":").append(ligands[i]).append(", ");
        }
        builder.append("}");
        return builder.toString();
    }
}

