/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.assembler.assemblers;

import com.hp.hpl.jena.assembler.Assembler;
import com.hp.hpl.jena.assembler.Content;
import com.hp.hpl.jena.assembler.JA;
import com.hp.hpl.jena.assembler.Mode;
import com.hp.hpl.jena.assembler.assemblers.AssemblerBase;
import com.hp.hpl.jena.assembler.exceptions.UnknownEncodingException;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.util.ResourceUtils;
import com.hp.hpl.jena.vocabulary.DC_11;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentAssembler
extends AssemblerBase
implements Assembler {
    protected final FileManager defaultFileManager;
    public static final Set<Property> contentProperties = new HashSetWith<Property>().with(JA.content).with(JA.literalContent).with(JA.externalContent).with(JA.quotedContent);
    static final String preamble = "@prefix rdf: <" + RDF.getURI() + "> ." + "\n@prefix rdfs: <" + RDFS.getURI() + "> ." + "\n@prefix owl: <" + OWL.getURI() + "> ." + "\n@prefix xsd: <http://www.w3.org/2001/XMLSchema#> ." + "\n@prefix dc: <" + DC_11.getURI() + "> .";

    public ContentAssembler() {
        this(null);
    }

    public ContentAssembler(FileManager fm) {
        this.defaultFileManager = fm;
    }

    @Override
    public Object open(Assembler a, Resource root, Mode irrelevant) {
        this.checkType(root, JA.Content);
        return new Content(this.loadContent(new ArrayList<Content>(), a, root));
    }

    public List<Content> loadContent(List<Content> contents, Assembler a, Resource root) {
        FileManager fm = this.getFileManager(a, root);
        ContentAssembler.addLiteralContent(contents, root);
        ContentAssembler.addQuotedContent(contents, root);
        this.addExternalContents(contents, fm, root);
        ContentAssembler.addIndirectContent(contents, a, root);
        return contents;
    }

    private static void addIndirectContent(List<Content> contents, Assembler a, Resource root) {
        StmtIterator it = root.listProperties(JA.content);
        while (it.hasNext()) {
            contents.add((Content)a.open(ContentAssembler.getResource(it.nextStatement())));
        }
    }

    protected void addExternalContents(List<Content> contents, FileManager fm, Resource root) {
        StmtIterator it = root.listProperties(JA.externalContent);
        while (it.hasNext()) {
            contents.add(this.objectAsContent(fm, it.nextStatement()));
        }
    }

    private static void addQuotedContent(List<Content> contents, Resource root) {
        StmtIterator it = root.listProperties(JA.quotedContent);
        while (it.hasNext()) {
            Resource q = ContentAssembler.getResource(it.nextStatement());
            Model m = ResourceUtils.reachableClosure(q);
            contents.add(ContentAssembler.newModelContent(m));
        }
    }

    protected static void addLiteralContent(List<Content> contents, Resource root) {
        String encoding = ContentAssembler.getEncoding(root);
        StmtIterator it = root.listProperties(JA.literalContent);
        while (it.hasNext()) {
            String s = ContentAssembler.getString(it.nextStatement());
            Model model = ContentAssembler.parseAs(root, encoding, s);
            contents.add(ContentAssembler.newModelContent(model));
        }
    }

    private static Model parseAs(Resource root, String encoding, String lexicalForm) {
        String enc;
        String string = enc = encoding == null ? ContentAssembler.guessFrom(lexicalForm) : encoding;
        if (enc.equals("N3")) {
            return ContentAssembler.parseAsN3(lexicalForm);
        }
        if (enc.equals("RDF/XML")) {
            return ContentAssembler.parseAsXML(lexicalForm);
        }
        throw new UnknownEncodingException(root, encoding);
    }

    private static Model parseAsXML(String lexicalForm) {
        String pre = "<?xml version='1.0'?><rdf:RDF xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#' xmlns:rdfs='http://www.w3.org/2000/01/rdf-schema#' xmlns:xsd='http://www.w3.org/2001/XMLSchema#' xmlns:owl='http://www.w3.org/2002/07/owl#' xmlns:dc='http://purl.org/dc/elements/1.1/'>";
        String post = "</rdf:RDF>";
        StringReader r = new StringReader(pre + lexicalForm + post);
        return ModelFactory.createDefaultModel().read(r, "", "RDF/XML");
    }

    private static String guessFrom(String lexicalForm) {
        return "N3";
    }

    private static String getEncoding(Resource root) {
        Literal L = ContentAssembler.getUniqueLiteral(root, JA.contentEncoding);
        return L == null ? null : L.getLexicalForm();
    }

    protected static Content newModelContent(final Model m) {
        return new Content(){

            public Model fill(Model x) {
                x.setNsPrefixes(m);
                return x.add(m);
            }

            public boolean isEmpty() {
                return m.isEmpty();
            }
        };
    }

    protected Content objectAsContent(FileManager fm, Statement s) {
        Model m = fm.loadModel(this.getModelName(s));
        return ContentAssembler.newModelContent(m);
    }

    private String getModelName(Statement s) {
        Node o = s.getObject().asNode();
        return o.isLiteral() ? o.getLiteralLexicalForm() : o.getURI();
    }

    private FileManager getFileManager(Assembler a, Resource root) {
        Resource fm = ContentAssembler.getUniqueResource(root, JA.fileManager);
        return fm != null ? (FileManager)a.open(fm) : (this.defaultFileManager == null ? FileManager.get() : this.defaultFileManager);
    }

    protected static Model parseAsN3(String value) {
        Model result = ModelFactory.createDefaultModel();
        StringReader r = new StringReader(preamble + "\n" + value);
        result.read(r, "", "N3");
        return result;
    }

    public Object getFileManager() {
        return this.defaultFileManager;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class HashSetWith<T>
    extends HashSet<T> {
        HashSetWith() {
        }

        public HashSetWith<T> with(T x) {
            this.add(x);
            return this;
        }
    }
}

