/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.smsd.algorithm.vflib.builder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.smsd.algorithm.matchers.VFAtomMatcher;
import org.openscience.cdk.smsd.algorithm.matchers.VFBondMatcher;
import org.openscience.cdk.smsd.algorithm.vflib.builder.EdgeBuilder;
import org.openscience.cdk.smsd.algorithm.vflib.builder.NodeBuilder;
import org.openscience.cdk.smsd.algorithm.vflib.interfaces.IEdge;
import org.openscience.cdk.smsd.algorithm.vflib.interfaces.INode;
import org.openscience.cdk.smsd.algorithm.vflib.interfaces.IQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TestClass(value="org.openscience.cdk.smsd.algorithm.vflib.VFLibTest")
public class VFQueryBuilder
implements IQuery {
    private List<INode> nodesList = new ArrayList<INode>();
    private List<IEdge> edgesList = new ArrayList<IEdge>();
    private Map<INode, IAtom> nodeBondMap = new HashMap<INode, IAtom>();

    @Override
    public Iterable<IEdge> edges() {
        return Collections.unmodifiableList(this.edgesList);
    }

    @Override
    public Iterable<INode> nodes() {
        return Collections.unmodifiableList(this.nodesList);
    }

    @Override
    public INode getNode(int index) {
        return this.nodesList.get(index);
    }

    public INode getNode(IAtom atom) {
        for (Map.Entry<INode, IAtom> v : this.nodeBondMap.entrySet()) {
            if (!v.getValue().equals(atom)) continue;
            return v.getKey();
        }
        return null;
    }

    @Override
    public IEdge getEdge(int index) {
        return this.edgesList.get(index);
    }

    @Override
    public IEdge getEdge(INode source, INode target) {
        if (source == target) {
            return null;
        }
        NodeBuilder sourceImpl = (NodeBuilder)source;
        for (IEdge edge : sourceImpl.getEdges()) {
            if (edge.getSource() != target && edge.getTarget() != target) continue;
            return edge;
        }
        return null;
    }

    public INode addNode(VFAtomMatcher matcher, IAtom atom) {
        NodeBuilder node = new NodeBuilder(matcher);
        this.nodesList.add(node);
        this.nodeBondMap.put(node, atom);
        return node;
    }

    @Override
    public IAtom getAtom(INode node) {
        return this.nodeBondMap.get(node);
    }

    @Override
    public int countNodes() {
        return this.nodesList.size();
    }

    @Override
    public int countEdges() {
        return this.edgesList.size();
    }

    public IEdge connect(INode source, INode target, VFBondMatcher matcher) {
        NodeBuilder sourceImpl = (NodeBuilder)source;
        NodeBuilder targetImpl = (NodeBuilder)target;
        EdgeBuilder edge = new EdgeBuilder(sourceImpl, targetImpl, matcher);
        sourceImpl.addNeighbor(targetImpl);
        targetImpl.addNeighbor(sourceImpl);
        sourceImpl.addEdge(edge);
        targetImpl.addEdge(edge);
        this.edgesList.add(edge);
        return edge;
    }
}

