/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.aromaticity;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import org.openscience.cdk.aromaticity.ElectronDonation;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.ringsearch.RingSearch;

final class DaylightModel
extends ElectronDonation {
    private static final int CARBON = 6;
    private static final int NITROGEN = 7;
    private static final int OXYGEN = 8;
    private static final int PHOSPHORUS = 15;
    private static final int SULPHUR = 16;
    private static final int ARSENIC = 33;
    private static final int SELENIUM = 34;

    DaylightModel() {
    }

    @Override
    int[] contribution(IAtomContainer container, RingSearch ringSearch) {
        int n = container.getAtomCount();
        int[] degree = new int[n];
        int[] bondOrderSum = new int[n];
        int[] nCyclicPiBonds = new int[n];
        int[] exocyclicPiBond = new int[n];
        int[] electrons = new int[n];
        Arrays.fill(exocyclicPiBond, -1);
        HashMap<IAtom, Integer> atomIndex = Maps.newHashMapWithExpectedSize(n);
        for (int i = 0; i < n; ++i) {
            IAtom a = container.getAtom(i);
            atomIndex.put(a, i);
            degree[i] = Preconditions.checkNotNull(a.getImplicitHydrogenCount(), "Aromaticity model requires implicit hydrogen count is set.");
        }
        for (IBond bond : container.bonds()) {
            int u = (Integer)atomIndex.get(bond.getAtom(0));
            int v = (Integer)atomIndex.get(bond.getAtom(1));
            int n2 = u;
            degree[n2] = degree[n2] + 1;
            int n3 = v;
            degree[n3] = degree[n3] + 1;
            IBond.Order order = Preconditions.checkNotNull(bond.getOrder(), "Aromaticity model requires that bond orders must be set");
            switch (order) {
                case UNSET: {
                    throw new IllegalArgumentException("Aromaticity model requires that bond orders must be set");
                }
                case DOUBLE: {
                    if (ringSearch.cyclic(u, v)) {
                        int n4 = u;
                        nCyclicPiBonds[n4] = nCyclicPiBonds[n4] + 1;
                        int n5 = v;
                        nCyclicPiBonds[n5] = nCyclicPiBonds[n5] + 1;
                    } else {
                        exocyclicPiBond[u] = v;
                        exocyclicPiBond[v] = u;
                    }
                }
                case SINGLE: 
                case TRIPLE: 
                case QUADRUPLE: {
                    int n6 = u;
                    bondOrderSum[n6] = bondOrderSum[n6] + order.numeric();
                    int n7 = v;
                    bondOrderSum[n7] = bondOrderSum[n7] + order.numeric();
                }
            }
        }
        for (int i = 0; i < n; ++i) {
            int bondedValence;
            int charge;
            int element = this.element(container.getAtom(i));
            if (!DaylightModel.normal(element, charge = this.charge(container.getAtom(i)), bondedValence = bondOrderSum[i] + container.getAtom(i).getImplicitHydrogenCount())) {
                electrons[i] = -1;
                continue;
            }
            if (!DaylightModel.aromaticElement(element) || !ringSearch.cyclic(i) || degree[i] > 3 || nCyclicPiBonds[i] > 1) {
                electrons[i] = -1;
                continue;
            }
            if (exocyclicPiBond[i] >= 0) {
                electrons[i] = DaylightModel.exocyclicContribution(element, this.element(container.getAtom(exocyclicPiBond[i])), charge, nCyclicPiBonds[i]);
                continue;
            }
            if (nCyclicPiBonds[i] == 1) {
                electrons[i] = element == 33 ? -1 : 1;
                continue;
            }
            if (charge <= 0 && charge > -3) {
                if (this.valence(element, charge) - bondOrderSum[i] >= 2) {
                    electrons[i] = 2;
                    continue;
                }
                electrons[i] = -1;
                continue;
            }
            electrons[i] = element == 6 && charge > 0 ? 0 : -1;
        }
        return electrons;
    }

    private static int exocyclicContribution(int element, int otherElement, int charge, int nCyclic) {
        switch (element) {
            case 6: {
                return otherElement != 6 ? 0 : 1;
            }
            case 7: 
            case 15: {
                if (charge == 1) {
                    return 1;
                }
                if (charge == 0 && otherElement == 8 && nCyclic == 1) {
                    return 1;
                }
                return -1;
            }
            case 16: {
                return charge == 0 && otherElement == 8 ? 2 : -1;
            }
        }
        return -1;
    }

    private static boolean aromaticElement(int element) {
        switch (element) {
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 16: 
            case 33: 
            case 34: {
                return true;
            }
        }
        return false;
    }

    private static boolean normal(int element, int charge, int valence) {
        switch (element) {
            case 6: {
                if (charge == -1 || charge == 1) {
                    return valence == 3;
                }
                return charge == 0 && valence == 4;
            }
            case 7: 
            case 15: 
            case 33: {
                if (charge == -1) {
                    return valence == 2;
                }
                if (charge == 1) {
                    return valence == 4;
                }
                return charge == 0 && (valence == 3 || valence == 5 && element == 7);
            }
            case 8: {
                if (charge == 1) {
                    return valence == 3;
                }
                return charge == 0 && valence == 2;
            }
            case 16: 
            case 34: {
                if (charge == 1) {
                    return valence == 3;
                }
                return charge == 0 && (valence == 2 || valence == 4 || valence == 6);
            }
        }
        return false;
    }

    private int valence(int element, int charge) {
        return this.valence(element - charge);
    }

    private int valence(int element) {
        switch (element) {
            case 5: 
            case 13: 
            case 31: {
                return 3;
            }
            case 6: 
            case 14: 
            case 32: {
                return 4;
            }
            case 7: 
            case 15: 
            case 33: {
                return 5;
            }
            case 8: 
            case 16: 
            case 34: {
                return 6;
            }
            case 9: 
            case 17: 
            case 35: {
                return 7;
            }
        }
        throw new UnsupportedOperationException("Valence not yet handled for element with atomic number " + element);
    }

    private int element(IAtom atom) {
        Integer element = atom.getAtomicNumber();
        if (element != null) {
            return element;
        }
        if (atom instanceof IPseudoAtom) {
            return 0;
        }
        throw new IllegalArgumentException("Aromaiticty model requires atomic numbers to be set");
    }

    private int charge(IAtom atom) {
        return atom.getFormalCharge() != null ? atom.getFormalCharge() : 0;
    }
}

