/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.fingerprint;

import java.util.BitSet;
import java.util.Random;
import org.openscience.cdk.fingerprint.Fingerprinter;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;

public class GraphOnlyFingerprinter
extends Fingerprinter {
    public GraphOnlyFingerprinter() {
        super(1024, 8);
    }

    public GraphOnlyFingerprinter(int size) {
        super(size, 8);
    }

    public GraphOnlyFingerprinter(int size, int searchDepth) {
        super(size, searchDepth);
    }

    @Override
    protected String getBondSymbol(IBond bond) {
        return "";
    }

    public BitSet getBitFingerprint(IAtomContainer container, int size) throws Exception {
        int[] hashes = this.findPathes(container, super.getSearchDepth());
        BitSet bitSet = new BitSet(size);
        for (int hash : hashes) {
            bitSet.set(new Random(hash).nextInt(size));
        }
        return bitSet;
    }
}

