/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.hash.stereo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.openscience.cdk.hash.stereo.BasicPermutationParity;
import org.openscience.cdk.hash.stereo.GeometricParity;
import org.openscience.cdk.hash.stereo.GeometryEncoder;
import org.openscience.cdk.hash.stereo.MultiStereoEncoder;
import org.openscience.cdk.hash.stereo.PermutationParity;
import org.openscience.cdk.hash.stereo.StereoEncoder;
import org.openscience.cdk.hash.stereo.StereoEncoderFactory;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IStereoElement;
import org.openscience.cdk.interfaces.ITetrahedralChirality;

public final class TetrahedralElementEncoderFactory
implements StereoEncoderFactory {
    @Override
    public StereoEncoder create(IAtomContainer container, int[][] graph) {
        Map<IAtom, Integer> atomToIndex = null;
        ArrayList<StereoEncoder> encoders = new ArrayList<StereoEncoder>();
        for (IStereoElement se : container.stereoElements()) {
            if (!(se instanceof ITetrahedralChirality)) continue;
            atomToIndex = TetrahedralElementEncoderFactory.indexMap(atomToIndex, container);
            encoders.add(TetrahedralElementEncoderFactory.encoder((ITetrahedralChirality)se, atomToIndex));
        }
        return encoders.isEmpty() ? StereoEncoder.EMPTY : new MultiStereoEncoder(encoders);
    }

    private static GeometryEncoder encoder(ITetrahedralChirality tc, Map<IAtom, Integer> atomToIndex) {
        int parity;
        IAtom[] ligands = tc.getLigands();
        int centre = atomToIndex.get(tc.getChiralAtom());
        int[] indices = new int[4];
        int offset = -1;
        for (int i = 0; i < ligands.length; ++i) {
            indices[i] = atomToIndex.get(ligands[i]);
            if (indices[i] != centre) continue;
            offset = i;
        }
        int n = parity = tc.getStereo() == ITetrahedralChirality.Stereo.CLOCKWISE ? -1 : 1;
        if (offset >= 0) {
            for (int i = offset; i < indices.length - 1; ++i) {
                indices[i] = indices[i + 1];
            }
            if (Integer.lowestOneBit(3 - offset) == 1) {
                parity *= -1;
            }
            indices = Arrays.copyOf(indices, indices.length - 1);
        }
        return new GeometryEncoder(centre, (PermutationParity)new BasicPermutationParity(indices), GeometricParity.valueOf(parity));
    }

    private static Map<IAtom, Integer> indexMap(Map<IAtom, Integer> map, IAtomContainer container) {
        if (map != null) {
            return map;
        }
        map = new HashMap<IAtom, Integer>();
        for (IAtom a : container.atoms()) {
            map.put(a, map.size());
        }
        return map;
    }
}

