/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.bond;

import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.qsar.AbstractBondDescriptor;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.result.DoubleResult;
import org.openscience.cdk.tools.IonizationPotentialTool;
import org.openscience.cdk.tools.LonePairElectronChecker;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

@Deprecated
public class IPBondLearningDescriptor
extends AbstractBondDescriptor {
    private static final String[] DESCRIPTOR_NAMES = new String[]{"ipBondLearning"};

    @Override
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#ionizationPotential", this.getClass().getName(), "The Chemistry Development Kit");
    }

    @Override
    public void setParameters(Object[] params) throws CDKException {
    }

    @Override
    public Object[] getParameters() {
        return null;
    }

    @Override
    public String[] getDescriptorNames() {
        return DESCRIPTOR_NAMES;
    }

    private DescriptorValue getDummyDescriptorValue(Exception e) {
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new DoubleResult(Double.NaN), DESCRIPTOR_NAMES, e);
    }

    @Override
    public DescriptorValue calculate(IBond bond, IAtomContainer atomContainer) {
        double value = 0.0;
        String originalAtomtypeName1 = bond.getAtom(0).getAtomTypeName();
        Integer originalNeighborCount1 = bond.getAtom(0).getFormalNeighbourCount();
        IAtomType.Hybridization originalHybridization1 = bond.getAtom(0).getHybridization();
        Integer originalValency1 = bond.getAtom(0).getValency();
        String originalAtomtypeName2 = bond.getAtom(1).getAtomTypeName();
        Integer originalNeighborCount2 = bond.getAtom(1).getFormalNeighbourCount();
        IAtomType.Hybridization originalHybridization2 = bond.getAtom(1).getHybridization();
        Integer originalValency2 = bond.getAtom(1).getValency();
        Double originalBondOrderSum1 = bond.getAtom(0).getBondOrderSum();
        IBond.Order originalMaxBondOrder1 = bond.getAtom(0).getMaxBondOrder();
        Double originalBondOrderSum2 = bond.getAtom(1).getBondOrderSum();
        IBond.Order originalMaxBondOrder2 = bond.getAtom(1).getMaxBondOrder();
        if (!this.isCachedAtomContainer(atomContainer)) {
            try {
                AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(atomContainer);
                LonePairElectronChecker lpcheck = new LonePairElectronChecker();
                lpcheck.saturate(atomContainer);
            }
            catch (CDKException e) {
                return this.getDummyDescriptorValue(e);
            }
        }
        if (!bond.getOrder().equals((Object)IBond.Order.SINGLE)) {
            try {
                value = IonizationPotentialTool.predictIP(atomContainer, bond);
            }
            catch (CDKException e) {
                return this.getDummyDescriptorValue(e);
            }
        }
        bond.getAtom(0).setAtomTypeName(originalAtomtypeName1);
        bond.getAtom(0).setHybridization(originalHybridization1);
        bond.getAtom(0).setValency(originalValency1);
        bond.getAtom(0).setFormalNeighbourCount(originalNeighborCount1);
        bond.getAtom(1).setAtomTypeName(originalAtomtypeName2);
        bond.getAtom(1).setHybridization(originalHybridization2);
        bond.getAtom(1).setValency(originalValency2);
        bond.getAtom(1).setFormalNeighbourCount(originalNeighborCount2);
        bond.getAtom(0).setMaxBondOrder(originalMaxBondOrder1);
        bond.getAtom(0).setBondOrderSum(originalBondOrderSum1);
        bond.getAtom(1).setMaxBondOrder(originalMaxBondOrder2);
        bond.getAtom(1).setBondOrderSum(originalBondOrderSum2);
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new DoubleResult(value), DESCRIPTOR_NAMES);
    }

    @Override
    public String[] getParameterNames() {
        return new String[0];
    }

    @Override
    public Object getParameterType(String name) {
        return null;
    }
}

