/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.reaction.mechanism;

import java.util.ArrayList;
import java.util.List;
import org.openscience.cdk.atomtype.CDKAtomTypeMatcher;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.ConnectivityChecker;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.ILonePair;
import org.openscience.cdk.interfaces.IMapping;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.interfaces.ISingleElectron;
import org.openscience.cdk.reaction.IReactionMechanism;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;
import org.openscience.cdk.tools.manipulator.BondManipulator;

public class RearrangementChargeMechanism
implements IReactionMechanism {
    @Override
    public IReaction initiate(IAtomContainerSet atomContainerSet, ArrayList<IAtom> atomList, ArrayList<IBond> bondList) throws CDKException {
        IAtomContainer reactantCloned;
        CDKAtomTypeMatcher atMatcher = CDKAtomTypeMatcher.getInstance(atomContainerSet.getBuilder());
        if (atomContainerSet.getAtomContainerCount() != 1) {
            throw new CDKException("RearrangementChargeMechanism only expects one IAtomContainer");
        }
        if (atomList.size() != 3) {
            throw new CDKException("RearrangementChargeMechanism expects three atoms in the ArrayList");
        }
        if (bondList.size() != 2) {
            throw new CDKException("RearrangementChargeMechanism only expect one bond in the ArrayList");
        }
        IAtomContainer molecule = atomContainerSet.getAtomContainer(0);
        try {
            reactantCloned = molecule.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new CDKException("Could not clone IAtomContainer!", e);
        }
        IAtom atom1 = atomList.get(0);
        IAtom atom1C = reactantCloned.getAtom(molecule.getAtomNumber(atom1));
        IAtom atom3 = atomList.get(2);
        IAtom atom3C = reactantCloned.getAtom(molecule.getAtomNumber(atom3));
        IBond bond1 = bondList.get(0);
        int posBond1 = molecule.getBondNumber(bond1);
        IBond bond2 = bondList.get(1);
        int posBond2 = molecule.getBondNumber(bond2);
        BondManipulator.increaseBondOrder(reactantCloned.getBond(posBond1));
        if (bond2.getOrder() == IBond.Order.SINGLE) {
            reactantCloned.removeBond(reactantCloned.getBond(posBond2));
        } else {
            BondManipulator.decreaseBondOrder(reactantCloned.getBond(posBond2));
        }
        if (reactantCloned.getConnectedSingleElectronsCount(atom1C) > 0) {
            List<ISingleElectron> selectron = reactantCloned.getConnectedSingleElectronsList(atom1C);
            reactantCloned.removeSingleElectron(selectron.get(selectron.size() - 1));
            reactantCloned.addSingleElectron(bond2.getBuilder().newInstance(ISingleElectron.class, atom3C));
        } else if (atom1C.getFormalCharge() > 0) {
            int charge = atom1C.getFormalCharge();
            atom1C.setFormalCharge(charge - 1);
            charge = atom3C.getFormalCharge();
            atom3C.setFormalCharge(charge + 1);
        } else if (atom1C.getFormalCharge() < 1) {
            int charge = atom1C.getFormalCharge();
            atom1C.setFormalCharge(charge + 1);
            List<ILonePair> ln = reactantCloned.getConnectedLonePairsList(atom1C);
            reactantCloned.removeLonePair(ln.get(ln.size() - 1));
            atom1C.setFlag(32, false);
            charge = atom3C.getFormalCharge();
            atom3C.setFormalCharge(charge - 1);
            reactantCloned.addLonePair(bond2.getBuilder().newInstance(ILonePair.class, atom3C));
            atom3C.setFlag(32, false);
        } else {
            return null;
        }
        atom1C.setHybridization(null);
        atom3C.setHybridization(null);
        AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(reactantCloned);
        IAtomType type = atMatcher.findMatchingAtomType(reactantCloned, atom1C);
        if (type == null || type.getAtomTypeName().equals("X")) {
            return null;
        }
        type = atMatcher.findMatchingAtomType(reactantCloned, atom3C);
        if (type == null || type.getAtomTypeName().equals("X")) {
            return null;
        }
        IReaction reaction = bond2.getBuilder().newInstance(IReaction.class, new Object[0]);
        reaction.addReactant(molecule);
        for (IAtom atom : molecule.atoms()) {
            IMapping mapping = bond2.getBuilder().newInstance(IMapping.class, atom, reactantCloned.getAtom(molecule.getAtomNumber(atom)));
            reaction.addMapping(mapping);
        }
        if (bond2.getOrder() != IBond.Order.SINGLE) {
            reaction.addProduct(reactantCloned);
        } else {
            IAtomContainerSet moleculeSetP = ConnectivityChecker.partitionIntoMolecules(reactantCloned);
            for (int z = 0; z < moleculeSetP.getAtomContainerCount(); ++z) {
                reaction.addProduct(moleculeSetP.getAtomContainer(z));
            }
        }
        return reaction;
    }
}

