/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.hash;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.hash.EquivalentSetFinder;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.ringsearch.RingSearch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
@TestClass(value="org.openscience.cdk.hash.MinimumEquivalentCyclicSetUnionTest")
final class MinimumEquivalentCyclicSetUnion
extends EquivalentSetFinder {
    MinimumEquivalentCyclicSetUnion() {
    }

    @Override
    @TestMethod(value="testFind,testFind_Distinct,testScenario")
    public Set<Integer> find(long[] invariants, IAtomContainer container, int[][] graph) {
        int n = invariants.length;
        RingSearch ringSearch = new RingSearch(container, graph);
        TreeMap<Long, HashSet<Integer>> equivalent = new TreeMap<Long, HashSet<Integer>>();
        for (int i = 0; i < invariants.length; ++i) {
            Long invariant = invariants[i];
            HashSet<Integer> set = (HashSet<Integer>)equivalent.get(invariant);
            if (set == null) {
                if (!ringSearch.cyclic(i)) continue;
                set = new HashSet<Integer>(n / 2);
                set.add(i);
                equivalent.put(invariant, set);
                continue;
            }
            set.add(i);
        }
        int minSize = Integer.MAX_VALUE;
        Set min = Collections.emptySet();
        for (Map.Entry e : equivalent.entrySet()) {
            Set vertices = (Set)e.getValue();
            if (vertices.size() < minSize && vertices.size() > 1) {
                min = vertices;
                minSize = vertices.size();
                continue;
            }
            if (vertices.size() != minSize) continue;
            min.addAll(vertices);
        }
        return min;
    }
}

