/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io.formats;

import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.io.formats.IChemFormatMatcher;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.formats.SimpleChemFormatMatcher;

@TestClass(value="org.openscience.cdk.io.formats.MDLV2000FormatTest")
public class MDLV2000Format
extends SimpleChemFormatMatcher
implements IChemFormatMatcher {
    private static IResourceFormat myself = null;

    @TestMethod(value="testResourceFormatSet")
    public static IResourceFormat getInstance() {
        if (myself == null) {
            myself = new MDLV2000Format();
        }
        return myself;
    }

    @TestMethod(value="testGetFormatName")
    public String getFormatName() {
        return "MDL Molfile V2000";
    }

    @TestMethod(value="testGetMIMEType")
    public String getMIMEType() {
        return null;
    }

    @TestMethod(value="testGetPreferredNameExtension")
    public String getPreferredNameExtension() {
        return this.getNameExtensions()[0];
    }

    @TestMethod(value="testGetNameExtensions")
    public String[] getNameExtensions() {
        return new String[]{"mol"};
    }

    @TestMethod(value="testGetReaderClassName")
    public String getReaderClassName() {
        return "org.openscience.cdk.io.MDLV2000Reader";
    }

    @TestMethod(value="testGetWriterClassName")
    public String getWriterClassName() {
        return "org.openscience.cdk.io.MDLV2000Writer";
    }

    @TestMethod(value="testMatches")
    public boolean matches(int lineNumber, String line) {
        return lineNumber == 4 && (line.indexOf("v2000") >= 0 || line.indexOf("V2000") >= 0);
    }

    @TestMethod(value="testIsXMLBased")
    public boolean isXMLBased() {
        return false;
    }

    @TestMethod(value="testGetSupportedDataFeatures")
    public int getSupportedDataFeatures() {
        return this.getRequiredDataFeatures() | 1 | 2 | 0x200;
    }

    @TestMethod(value="testGetRequiredDataFeatures")
    public int getRequiredDataFeatures() {
        return 8;
    }
}

