/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io.setting;

import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.io.setting.IOSetting;

public class IntegerIOSetting
extends IOSetting {
    public IntegerIOSetting(String name, IOSetting.Importance level, String question, String defaultSetting) {
        super(name, level, question, defaultSetting);
    }

    public void setSetting(String setting) throws CDKException {
        try {
            Integer.parseInt(setting);
            this.setting = setting;
        }
        catch (NumberFormatException exception) {
            throw new CDKException("Setting " + setting + " is not an integer.", exception);
        }
    }

    public int getSettingValue() {
        return Integer.parseInt(this.setting);
    }
}

