/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.molecular;

import java.util.List;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.atomtype.CDKAtomTypeMatcher;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.exception.InvalidSmilesException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.isomorphism.matchers.QueryAtomContainer;
import org.openscience.cdk.isomorphism.matchers.QueryAtomContainerCreator;
import org.openscience.cdk.qsar.AbstractMolecularDescriptor;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.descriptors.molecular.ChiIndexUtils;
import org.openscience.cdk.qsar.result.DoubleArrayResult;
import org.openscience.cdk.qsar.result.DoubleArrayResultType;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.smiles.SmilesParser;
import org.openscience.cdk.tools.CDKHydrogenAdder;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;
import org.openscience.cdk.tools.manipulator.AtomTypeManipulator;

@TestClass(value="org.openscience.cdk.qsar.descriptors.molecular.ChiPathClusterDescriptorTest")
public class ChiPathClusterDescriptor
extends AbstractMolecularDescriptor
implements IMolecularDescriptor {
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(ChiPathClusterDescriptor.class);
    private SmilesParser sp;
    private static final String[] names = new String[]{"SPC-4", "SPC-5", "SPC-6", "VPC-4", "VPC-5", "VPC-6"};

    @TestMethod(value="testGetSpecification")
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#chiPathCluster", this.getClass().getName(), "$Id: 66f2587cd35dc4f06fca9f247d170a254e72c5c1 $", "The Chemistry Development Kit");
    }

    @TestMethod(value="testGetParameterNames")
    public String[] getParameterNames() {
        return null;
    }

    @TestMethod(value="testGetParameterType_String")
    public Object getParameterType(String name) {
        return null;
    }

    @TestMethod(value="testSetParameters_arrayObject")
    public void setParameters(Object[] params) throws CDKException {
    }

    @TestMethod(value="testGetParameters")
    public Object[] getParameters() {
        return null;
    }

    @TestMethod(value="testNamesConsistency")
    public String[] getDescriptorNames() {
        return names;
    }

    @TestMethod(value="testCalculate_IAtomContainer")
    public DescriptorValue calculate(IAtomContainer container) {
        double order6v;
        double order5v;
        double order4v;
        if (this.sp == null) {
            this.sp = new SmilesParser(container.getBuilder());
        }
        IAtomContainer localAtomContainer = AtomContainerManipulator.removeHydrogens(container);
        CDKAtomTypeMatcher matcher = CDKAtomTypeMatcher.getInstance(container.getBuilder());
        for (IAtom atom : localAtomContainer.atoms()) {
            try {
                IAtomType type = matcher.findMatchingAtomType(localAtomContainer, atom);
                AtomTypeManipulator.configure(atom, type);
            }
            catch (Exception e) {
                return this.getDummyDescriptorValue(new CDKException("Error in atom typing: " + e.getMessage()));
            }
        }
        CDKHydrogenAdder hAdder = CDKHydrogenAdder.getInstance(container.getBuilder());
        try {
            hAdder.addImplicitHydrogens(localAtomContainer);
        }
        catch (Exception e) {
            return this.getDummyDescriptorValue(new CDKException("Error in hydrogen addition: " + e.getMessage()));
        }
        List subgraph4 = this.order4(localAtomContainer);
        List subgraph5 = this.order5(localAtomContainer);
        List subgraph6 = this.order6(localAtomContainer);
        double order4s = ChiIndexUtils.evalSimpleIndex(localAtomContainer, subgraph4);
        double order5s = ChiIndexUtils.evalSimpleIndex(localAtomContainer, subgraph5);
        double order6s = ChiIndexUtils.evalSimpleIndex(localAtomContainer, subgraph6);
        try {
            order4v = ChiIndexUtils.evalValenceIndex(localAtomContainer, subgraph4);
            order5v = ChiIndexUtils.evalValenceIndex(localAtomContainer, subgraph5);
            order6v = ChiIndexUtils.evalValenceIndex(localAtomContainer, subgraph6);
        }
        catch (CDKException e) {
            return this.getDummyDescriptorValue(new CDKException("Error in substructure search: " + e.getMessage()));
        }
        DoubleArrayResult retval = new DoubleArrayResult();
        retval.add(order4s);
        retval.add(order5s);
        retval.add(order6s);
        retval.add(order4v);
        retval.add(order5v);
        retval.add(order6v);
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), retval, this.getDescriptorNames());
    }

    private DescriptorValue getDummyDescriptorValue(Exception e) {
        int ndesc = this.getDescriptorNames().length;
        DoubleArrayResult results = new DoubleArrayResult(ndesc);
        for (int i = 0; i < ndesc; ++i) {
            results.add(Double.NaN);
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), results, this.getDescriptorNames(), e);
    }

    @TestMethod(value="testGetDescriptorResultType")
    public IDescriptorResult getDescriptorResultType() {
        return new DoubleArrayResultType(6);
    }

    private List order4(IAtomContainer atomContainer) {
        QueryAtomContainer[] queries = new QueryAtomContainer[1];
        try {
            queries[0] = QueryAtomContainerCreator.createAnyAtomAnyBondContainer(this.sp.parseSmiles("CC(C)CC"), false);
        }
        catch (InvalidSmilesException e) {
            e.printStackTrace();
        }
        return ChiIndexUtils.getFragments(atomContainer, queries);
    }

    private List order5(IAtomContainer atomContainer) {
        QueryAtomContainer[] queries = new QueryAtomContainer[3];
        try {
            queries[0] = QueryAtomContainerCreator.createAnyAtomAnyBondContainer(this.sp.parseSmiles("CC(C)CCC"), false);
            queries[1] = QueryAtomContainerCreator.createAnyAtomAnyBondContainer(this.sp.parseSmiles("CC(C)(C)CC"), false);
            queries[2] = QueryAtomContainerCreator.createAnyAtomAnyBondContainer(this.sp.parseSmiles("CCC(C)CC"), false);
        }
        catch (InvalidSmilesException e) {
            e.printStackTrace();
        }
        return ChiIndexUtils.getFragments(atomContainer, queries);
    }

    private List order6(IAtomContainer atomContainer) {
        QueryAtomContainer[] queries = new QueryAtomContainer[5];
        try {
            queries[0] = QueryAtomContainerCreator.createAnyAtomAnyBondContainer(this.sp.parseSmiles("CC(C)(C)CCC"), false);
            queries[1] = QueryAtomContainerCreator.createAnyAtomAnyBondContainer(this.sp.parseSmiles("CC(C)C(C)CC"), false);
            queries[2] = QueryAtomContainerCreator.createAnyAtomAnyBondContainer(this.sp.parseSmiles("CC(C)CC(C)C"), false);
            queries[3] = QueryAtomContainerCreator.createAnyAtomAnyBondContainer(this.sp.parseSmiles("CC(C)CCCC"), false);
            queries[4] = QueryAtomContainerCreator.createAnyAtomAnyBondContainer(this.sp.parseSmiles("CCC(C)CCC"), false);
        }
        catch (InvalidSmilesException e) {
            e.printStackTrace();
        }
        return ChiIndexUtils.getFragments(atomContainer, queries);
    }
}

