/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.reaction.mechanism;

import java.util.ArrayList;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.atomtype.CDKAtomTypeMatcher;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IMapping;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.reaction.IReactionMechanism;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;
import org.openscience.cdk.tools.manipulator.BondManipulator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TestClass(value="org.openscience.cdk.reaction.mechanism.AdductionPBMechanismTest")
public class AdductionPBMechanism
implements IReactionMechanism {
    @Override
    @TestMethod(value="testInitiate_IAtomContainerSet_ArrayList_ArrayList")
    public IReaction initiate(IAtomContainerSet atomContainerSet, ArrayList<IAtom> atomList, ArrayList<IBond> bondList) throws CDKException {
        IMapping mapping;
        IAtomContainer reactantCloned;
        CDKAtomTypeMatcher atMatcher = CDKAtomTypeMatcher.getInstance(atomContainerSet.getBuilder());
        if (atomContainerSet.getAtomContainerCount() != 2) {
            throw new CDKException("AdductionPBMechanism expects two IMolecule's");
        }
        if (atomList.size() != 3) {
            throw new CDKException("AdductionPBMechanism expects two atoms in the ArrayList");
        }
        if (bondList.size() != 1) {
            throw new CDKException("AdductionPBMechanism don't expect bonds in the ArrayList");
        }
        IAtomContainer molecule1 = atomContainerSet.getAtomContainer(0);
        IAtomContainer molecule2 = atomContainerSet.getAtomContainer(1);
        try {
            reactantCloned = atomContainerSet.getAtomContainer(0).clone();
            reactantCloned.add(atomContainerSet.getAtomContainer(1).clone());
        }
        catch (CloneNotSupportedException e) {
            throw new CDKException("Could not clone IMolecule!", e);
        }
        IAtom atom1 = atomList.get(0);
        IAtom atom1C = reactantCloned.getAtom(molecule1.getAtomNumber(atom1));
        IAtom atom2 = atomList.get(1);
        IAtom atom2C = reactantCloned.getAtom(molecule1.getAtomNumber(atom2));
        IAtom atom3 = atomList.get(2);
        IAtom atom3C = reactantCloned.getAtom(molecule1.getAtomCount() + molecule2.getAtomNumber(atom3));
        IBond bond1 = bondList.get(0);
        int posBond1 = atomContainerSet.getAtomContainer(0).getBondNumber(bond1);
        BondManipulator.decreaseBondOrder(reactantCloned.getBond(posBond1));
        IBond newBond = molecule1.getBuilder().newInstance(IBond.class, new Object[]{atom2C, atom3C, IBond.Order.SINGLE});
        reactantCloned.addBond(newBond);
        int charge = atom1C.getFormalCharge();
        atom1C.setFormalCharge(charge + 1);
        atom1C.setHybridization(null);
        AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(reactantCloned);
        IAtomType type = atMatcher.findMatchingAtomType(reactantCloned, atom1C);
        if (type == null) {
            return null;
        }
        atom2C.setHybridization(null);
        AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(reactantCloned);
        type = atMatcher.findMatchingAtomType(reactantCloned, atom2C);
        if (type == null) {
            return null;
        }
        charge = atom3C.getFormalCharge();
        atom3C.setFormalCharge(charge - 1);
        atom3C.setHybridization(null);
        AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(reactantCloned);
        type = atMatcher.findMatchingAtomType(reactantCloned, atom3C);
        if (type == null) {
            return null;
        }
        IReaction reaction = atom1C.getBuilder().newInstance(IReaction.class, new Object[0]);
        reaction.addReactant(molecule1);
        for (IAtom atom : molecule1.atoms()) {
            mapping = atom1C.getBuilder().newInstance(IMapping.class, atom, reactantCloned.getAtom(molecule1.getAtomNumber(atom)));
            reaction.addMapping(mapping);
        }
        for (IAtom atom : molecule2.atoms()) {
            mapping = atom1C.getBuilder().newInstance(IMapping.class, atom, reactantCloned.getAtom(molecule2.getAtomNumber(atom)));
            reaction.addMapping(mapping);
        }
        reaction.addProduct(reactantCloned);
        return reaction;
    }
}

