/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.elements.path;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Point2d;
import org.openscience.cdk.renderer.elements.GeneralPath;
import org.openscience.cdk.renderer.elements.path.Close;
import org.openscience.cdk.renderer.elements.path.CubicTo;
import org.openscience.cdk.renderer.elements.path.LineTo;
import org.openscience.cdk.renderer.elements.path.MoveTo;
import org.openscience.cdk.renderer.elements.path.PathElement;
import org.openscience.cdk.renderer.elements.path.QuadTo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathBuilder {
    private List<PathElement> elements = new ArrayList<PathElement>();
    private Color color;

    public PathBuilder() {
        this(Color.BLACK);
    }

    public PathBuilder(Color color) {
        this.color = color;
    }

    private <T extends PathElement> void add(T element) {
        this.elements.add(element);
    }

    public PathBuilder moveTo(Point2d point) {
        this.add(new MoveTo(point));
        return this;
    }

    public PathBuilder lineTo(Point2d point) {
        this.add(new LineTo(point));
        return this;
    }

    public PathBuilder quadTo(Point2d cp, Point2d ep) {
        this.add(new QuadTo(cp, ep));
        return this;
    }

    public PathBuilder cubicTo(Point2d cp1, Point2d cp2, Point2d ep) {
        this.add(new CubicTo(cp1, cp2, ep));
        return this;
    }

    public void close() {
        this.add(new Close());
    }

    public PathBuilder color(Color color) {
        this.color = color;
        return this;
    }

    public GeneralPath createPath() {
        return new GeneralPath(this.elements, this.color);
    }
}

