/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.beam;

import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import uk.ac.ebi.beam.ArbitraryMatching;
import uk.ac.ebi.beam.Atom;
import uk.ac.ebi.beam.Bond;
import uk.ac.ebi.beam.Edge;
import uk.ac.ebi.beam.Element;
import uk.ac.ebi.beam.Graph;
import uk.ac.ebi.beam.IntSet;
import uk.ac.ebi.beam.InvalidSmilesException;
import uk.ac.ebi.beam.Matching;
import uk.ac.ebi.beam.MaximumMatching;
import uk.ac.ebi.beam.Tuple;

final class Localise {
    private final Graph delocalised;
    private final Graph localised;
    private final BitSet subset;
    private final Map<Edge, Edge> edgeAssignments = new HashMap<Edge, Edge>();

    private Localise(Graph delocalised, BitSet subset) throws InvalidSmilesException {
        this.delocalised = delocalised;
        this.localised = new Graph(delocalised.order());
        this.subset = subset;
        Matching m = MaximumMatching.maximise(delocalised, ArbitraryMatching.of(delocalised, subset), IntSet.fromBitSet(subset));
        for (Tuple tuple : m.matches()) {
            int u = tuple.first();
            int v = tuple.second();
            this.edgeAssignments.put(delocalised.edge(u, v), Bond.DOUBLE.edge(u, v));
        }
        for (int v = 0; v < delocalised.order(); ++v) {
            this.localised.addAtom(delocalised.atom(v).toAliphatic());
            this.localised.addTopology(delocalised.topologyOf(v));
        }
        for (Edge orgEdge : delocalised.edges()) {
            Edge newEdge = this.edgeAssignments.get(orgEdge);
            if (newEdge != null) {
                this.localised.addEdge(newEdge);
                continue;
            }
            if (orgEdge.bond() == Bond.AROMATIC || orgEdge.bond() == Bond.SINGLE) {
                this.localised.addEdge(Bond.IMPLICIT.edge(orgEdge.either(), orgEdge.other(orgEdge.either())));
                continue;
            }
            this.localised.addEdge(orgEdge);
        }
        for (int v = 0; v < delocalised.order(); ++v) {
            if (this.localised.implHCount(v) == delocalised.implHCount(v)) continue;
            throw new InvalidSmilesException("cannot assign localised bonds to structure - valence error");
        }
    }

    static BitSet buildSet(Graph g) {
        BitSet undecided = new BitSet(g.order());
        for (int v = 0; v < g.order(); ++v) {
            if (!g.atom(v).aromatic()) continue;
            undecided.set(v, !Localise.predetermined(g, v));
        }
        return undecided;
    }

    static boolean predetermined(Graph g, int v) {
        Atom a = g.atom(v);
        int q = a.charge();
        int deg = g.degree(v) + g.implHCount(v);
        for (Edge e : g.edges(v)) {
            if (e.bond() == Bond.DOUBLE) {
                return q != 0 || a.element() != Element.Nitrogen && (a.element() != Element.Sulfur || deg <= 3) || g.atom(e.other(v)).element() != Element.Oxygen;
            }
            if (e.bond().order() <= 2) continue;
            return true;
        }
        switch (a.element()) {
            case Carbon: {
                if (q == 1 && deg == 3) {
                    return true;
                }
            }
            case Silicon: 
            case Germanium: {
                return q < 0;
            }
            case Nitrogen: 
            case Phosphorus: 
            case Arsenic: 
            case Antimony: {
                if (q == 0) {
                    return deg == 3;
                }
                if (q == 1) {
                    return deg != 3;
                }
                return true;
            }
            case Oxygen: 
            case Sulfur: 
            case Selenium: 
            case Tellurium: {
                if (q == 0) {
                    return deg == 2;
                }
                return false;
            }
        }
        return false;
    }

    static Graph localise(Graph delocalised) throws InvalidSmilesException {
        if (!delocalised.isDelocalised()) {
            return delocalised;
        }
        BitSet subset = Localise.buildSet(delocalised);
        if (Localise.hasOddCardinality(subset)) {
            throw new InvalidSmilesException("No localised structure can be assigned.");
        }
        return new Localise((Graph)delocalised, (BitSet)subset).localised;
    }

    private static boolean hasOddCardinality(BitSet s) {
        return (s.cardinality() & 1) == 1;
    }
}

