/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.molecular;

import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.config.Isotopes;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IElement;
import org.openscience.cdk.qsar.AbstractMolecularDescriptor;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.DoubleResult;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

@TestClass(value="org.openscience.cdk.qsar.descriptors.molecular.BPolDescriptorTest")
public class BPolDescriptor
extends AbstractMolecularDescriptor
implements IMolecularDescriptor {
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(BPolDescriptor.class);
    private static double[] polarizabilities;
    private static final String[] names;

    public BPolDescriptor() {
        if (polarizabilities == null) {
            polarizabilities = new double[]{0.0, 0.666793, 0.204956, 24.3, 5.6, 3.03, 1.76, 1.1, 0.802, 0.557, 0.3956, 23.6, 10.6, 6.8, 5.38, 3.63, 2.9, 2.18, 1.6411, 43.4, 22.8, 17.8, 14.6, 12.4, 11.6, 9.4, 8.4, 7.5, 6.8, 6.1, 7.1, 8.12, 6.07, 4.31, 3.77, 3.05, 2.4844, 47.3, 27.6, 22.7, 17.9, 15.7, 12.8, 11.4, 9.6, 8.6, 4.8, 7.2, 7.2, 10.2, 7.7, 6.6, 5.5, 5.35, 4.044, 59.6, 39.7, 31.1, 29.6, 28.2, 31.4, 30.1, 28.8, 27.7, 23.5, 25.5, 24.5, 23.6, 22.7, 21.8, 21.0, 21.9, 16.2, 13.1, 11.1, 9.7, 8.5, 7.6, 6.5, 5.8, 5.7, 7.6, 6.8, 7.4, 6.8, 6.0, 5.3, 48.7, 38.3, 32.1, 32.1, 25.4, 27.4, 24.8, 24.5, 23.3, 23.0, 22.7, 20.5, 19.7, 23.8, 18.2, 17.5};
        }
    }

    @Override
    @TestMethod(value="testGetSpecification")
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#bpol", this.getClass().getName(), "The Chemistry Development Kit");
    }

    @Override
    @TestMethod(value="testSetParameters_arrayObject")
    public void setParameters(Object[] params) throws CDKException {
    }

    @Override
    @TestMethod(value="testGetParameters")
    public Object[] getParameters() {
        return null;
    }

    @Override
    @TestMethod(value="testNamesConsistency")
    public String[] getDescriptorNames() {
        return names;
    }

    @Override
    @TestMethod(value="testCalculate_IAtomContainer")
    public DescriptorValue calculate(IAtomContainer container) {
        double bpol = 0.0;
        try {
            double difference;
            Isotopes ifac = Isotopes.getInstance();
            for (IBond bond : container.bonds()) {
                IAtom atom0 = bond.getAtom(0);
                IAtom atom1 = bond.getAtom(1);
                String symbol0 = atom0.getSymbol();
                String symbol1 = atom1.getSymbol();
                IElement element0 = ifac.getElement(symbol0);
                IElement element1 = ifac.getElement(symbol1);
                int atomicNumber0 = element0.getAtomicNumber();
                int atomicNumber1 = element1.getAtomicNumber();
                difference = polarizabilities[atomicNumber0] - polarizabilities[atomicNumber1];
                bpol += Math.abs(difference);
            }
            for (IAtom atom : container.atoms()) {
                int impH = atom.getImplicitHydrogenCount() == CDKConstants.UNSET ? 0 : atom.getImplicitHydrogenCount();
                IElement elem = ifac.getElement(atom.getSymbol());
                int atnum = elem.getAtomicNumber();
                difference = Math.abs(polarizabilities[atnum] - polarizabilities[1]) * (double)impH;
                bpol += difference;
            }
            return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new DoubleResult(bpol), this.getDescriptorNames());
        }
        catch (Exception ex1) {
            logger.debug(ex1);
            return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new DoubleResult(Double.NaN), this.getDescriptorNames(), new CDKException("Problems with IsotopeFactory due to " + ex1.toString(), ex1));
        }
    }

    @Override
    @TestMethod(value="testGetDescriptorResultType")
    public IDescriptorResult getDescriptorResultType() {
        return new DoubleResult(0.0);
    }

    @Override
    @TestMethod(value="testGetParameterNames")
    public String[] getParameterNames() {
        return null;
    }

    @Override
    @TestMethod(value="testGetParameterType_String")
    public Object getParameterType(String name) {
        return null;
    }

    static {
        names = new String[]{"bpol"};
    }
}

