/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.ringsearch;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org._3pq.jgrapht.UndirectedGraph;
import org._3pq.jgrapht.graph.SimpleGraph;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.graph.MoleculeGraphs;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IElectronContainer;
import org.openscience.cdk.interfaces.IRing;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.ringsearch.cyclebasis.CycleBasis;
import org.openscience.cdk.ringsearch.cyclebasis.SimpleCycle;

@TestClass(value="org.openscience.cdk.ringsearch.SSSRFinderTest")
public class SSSRFinder {
    private IAtomContainer atomContainer;
    private CycleBasis cycleBasis;

    public SSSRFinder(IAtomContainer container) {
        this.atomContainer = container;
    }

    @TestMethod(value="testFindSSSR,testFindSSSR_IAtomContainer")
    public IRingSet findSSSR() {
        if (this.atomContainer == null) {
            return null;
        }
        IRingSet ringSet = SSSRFinder.toRingSet(this.atomContainer, this.cycleBasis().cycles());
        return ringSet;
    }

    public IRingSet findEssentialRings() {
        if (this.atomContainer == null) {
            return null;
        }
        IRingSet ringSet = SSSRFinder.toRingSet(this.atomContainer, this.cycleBasis().essentialCycles());
        return ringSet;
    }

    public IRingSet findRelevantRings() {
        if (this.atomContainer == null) {
            return null;
        }
        IRingSet ringSet = SSSRFinder.toRingSet(this.atomContainer, this.cycleBasis().relevantCycles().keySet());
        return ringSet;
    }

    public List findEquivalenceClasses() {
        if (this.atomContainer == null) {
            return null;
        }
        ArrayList<IRingSet> equivalenceClasses = new ArrayList<IRingSet>();
        for (Object o : this.cycleBasis().equivalenceClasses()) {
            equivalenceClasses.add(SSSRFinder.toRingSet(this.atomContainer, (Collection)o));
        }
        return equivalenceClasses;
    }

    public int[] getSSSRWeightVector() {
        return this.cycleBasis().weightVector();
    }

    public int[] getEquivalenceClassesSizeVector() {
        List equivalenceClasses = this.cycleBasis().equivalenceClasses();
        int[] result = new int[equivalenceClasses.size()];
        for (int i = 0; i < equivalenceClasses.size(); ++i) {
            result[i] = ((Collection)equivalenceClasses.get(i)).size();
        }
        return result;
    }

    private CycleBasis cycleBasis() {
        if (this.cycleBasis == null) {
            SimpleGraph molGraph = MoleculeGraphs.getMoleculeGraph(this.atomContainer);
            this.cycleBasis = new CycleBasis((UndirectedGraph)molGraph);
        }
        return this.cycleBasis;
    }

    private static IRingSet toRingSet(IAtomContainer container, Collection cycles) {
        IRingSet ringSet = (IRingSet)container.getBuilder().newInstance(IRingSet.class, new Object[0]);
        for (SimpleCycle cycle : cycles) {
            IRing ring = (IRing)container.getBuilder().newInstance(IRing.class, new Object[0]);
            List vertices = cycle.vertexList();
            IAtom[] atoms = new IAtom[vertices.size()];
            atoms[0] = (IAtom)vertices.get(0);
            for (int i = 1; i < vertices.size(); ++i) {
                atoms[i] = (IAtom)vertices.get(i);
                ring.addElectronContainer((IElectronContainer)container.getBond(atoms[i - 1], atoms[i]));
            }
            for (IAtom atom : atoms) {
                atom.setFlag(2, true);
            }
            ring.addElectronContainer((IElectronContainer)container.getBond(atoms[vertices.size() - 1], atoms[0]));
            ring.setAtoms(atoms);
            ringSet.addAtomContainer((IAtomContainer)ring);
        }
        return ringSet;
    }
}

