/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.smiles;

import java.io.Serializable;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.math.Primes;

public class InvPair
implements Serializable {
    private static final long serialVersionUID = -1397634098919863122L;
    public static final String INVARIANCE_PAIR = "InvariancePair";
    public static final String CANONICAL_LABEL = "CanonicalLabel";
    private long last = 0L;
    private long curr = 0L;
    private IAtom atom;
    private int prime;

    public InvPair() {
    }

    public InvPair(long current, IAtom atom) {
        this.curr = current;
        this.atom = atom;
        atom.setProperty(INVARIANCE_PAIR, this);
    }

    public long getLast() {
        return this.last;
    }

    public void setCurr(long newCurr) {
        this.curr = newCurr;
    }

    public long getCurr() {
        return this.curr;
    }

    public boolean equals(Object object) {
        if (object instanceof InvPair) {
            InvPair o = (InvPair)object;
            return this.last == o.getLast() && this.curr == o.getCurr();
        }
        return false;
    }

    public void setLast(long newLast) {
        this.last = newLast;
    }

    public void setAtom(IAtom newAtom) {
        this.atom = newAtom;
    }

    public IAtom getAtom() {
        return this.atom;
    }

    public void commit() {
        this.atom.setProperty(CANONICAL_LABEL, this.curr);
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        buff.append(this.curr);
        buff.append('\t');
        return buff.toString();
    }

    public int getPrime() {
        return this.prime;
    }

    public void setPrime() {
        this.prime = Primes.getPrimeAt((int)this.curr - 1);
    }
}

