/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.smiles;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import org.openscience.cdk.exception.InvalidSmilesException;
import org.openscience.cdk.graph.ConnectivityChecker;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.interfaces.ISingleElectron;
import org.openscience.cdk.sgroup.Sgroup;
import org.openscience.cdk.sgroup.SgroupKey;
import org.openscience.cdk.sgroup.SgroupType;
import org.openscience.cdk.smiles.BeamToCDK;
import org.openscience.cdk.smiles.CxSmilesParser;
import org.openscience.cdk.smiles.CxSmilesState;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;
import uk.ac.ebi.beam.Graph;

public final class SmilesParser {
    private ILoggingTool logger = LoggingToolFactory.createLoggingTool(SmilesParser.class);
    private final IChemObjectBuilder builder;
    private final BeamToCDK beamToCDK;
    private boolean kekulise = true;
    private boolean strict = false;

    public SmilesParser(IChemObjectBuilder builder) {
        this.builder = builder;
        this.beamToCDK = new BeamToCDK(builder);
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public IReaction parseReactionSmiles(String smiles) throws InvalidSmilesException {
        int i;
        if (!smiles.contains(">")) {
            throw new InvalidSmilesException("Not a reaction SMILES: " + smiles);
        }
        int first = smiles.indexOf(62);
        int second = smiles.indexOf(62, first + 1);
        if (second < 0) {
            throw new InvalidSmilesException("Invalid reaction SMILES:" + smiles);
        }
        String reactants = smiles.substring(0, first);
        String agents = smiles.substring(first + 1, second);
        String products = smiles.substring(second + 1, smiles.length());
        IReaction reaction = this.builder.newInstance(IReaction.class, new Object[0]);
        if (!reactants.isEmpty()) {
            IAtomContainer reactantContainer = this.parseSmiles(reactants, true);
            IAtomContainerSet reactantSet = ConnectivityChecker.partitionIntoMolecules(reactantContainer);
            for (i = 0; i < reactantSet.getAtomContainerCount(); ++i) {
                reaction.addReactant(reactantSet.getAtomContainer(i));
            }
        }
        if (!agents.isEmpty()) {
            IAtomContainer agentContainer = this.parseSmiles(agents, true);
            IAtomContainerSet agentSet = ConnectivityChecker.partitionIntoMolecules(agentContainer);
            for (i = 0; i < agentSet.getAtomContainerCount(); ++i) {
                reaction.addAgent(agentSet.getAtomContainer(i));
            }
        }
        String title = null;
        if (!products.isEmpty()) {
            IAtomContainer productContainer = this.parseSmiles(products, true);
            IAtomContainerSet productSet = ConnectivityChecker.partitionIntoMolecules(productContainer);
            for (int i2 = 0; i2 < productSet.getAtomContainerCount(); ++i2) {
                reaction.addProduct(productSet.getAtomContainer(i2));
            }
            title = (String)productContainer.getProperty("cdk:Title");
            reaction.setProperty("cdk:Title", title);
        }
        try {
            this.parseRxnCXSMILES(title, reaction);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new InvalidSmilesException("Error parsing CXSMILES:" + e.getMessage());
        }
        return reaction;
    }

    public IAtomContainer parseSmiles(String smiles) throws InvalidSmilesException {
        return this.parseSmiles(smiles, false);
    }

    private IAtomContainer parseSmiles(String smiles, boolean isRxnPart) throws InvalidSmilesException {
        try {
            HashSet<String> warnings = new HashSet<String>();
            Graph g = Graph.parse(smiles, this.strict, warnings);
            for (String warning : warnings) {
                this.logger.warn(warning);
            }
            IAtomContainer mol = this.beamToCDK.toAtomContainer(this.kekulise ? g.kekule() : g, this.kekulise);
            if (!isRxnPart) {
                try {
                    this.parseMolCXSMILES(g.getTitle(), mol);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new InvalidSmilesException("Error parsing CXSMILES:" + e.getMessage());
                }
            }
            return mol;
        }
        catch (IOException e) {
            throw new InvalidSmilesException("could not parse '" + smiles + "', " + e.getMessage());
        }
        catch (Exception e) {
            throw new InvalidSmilesException("could not parse '" + smiles + "'");
        }
    }

    private int parseIntSafe(String val) {
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private void parseMolCXSMILES(String title, IAtomContainer mol) {
        CxSmilesState cxstate;
        int pos;
        if (title != null && title.startsWith("|") && (pos = CxSmilesParser.processCx(title, cxstate = new CxSmilesState())) >= 0) {
            mol.setTitle(title.substring(pos));
            HashMap<IAtom, IAtomContainer> atomToMol = Maps.newHashMapWithExpectedSize(mol.getAtomCount());
            ArrayList<IAtom> atoms = new ArrayList<IAtom>(mol.getAtomCount());
            for (IAtom atom : mol.atoms()) {
                atoms.add(atom);
                atomToMol.put(atom, mol);
            }
            this.assignCxSmilesInfo(mol.getBuilder(), mol, atoms, atomToMol, cxstate);
        }
    }

    private void parseRxnCXSMILES(String title, IReaction rxn) {
        CxSmilesState cxstate;
        int pos;
        if (title != null && title.startsWith("|") && (pos = CxSmilesParser.processCx(title, cxstate = new CxSmilesState())) >= 0) {
            rxn.setProperty("cdk:Title", title.substring(pos));
            HashMap<IAtom, IAtomContainer> atomToMol = new HashMap<IAtom, IAtomContainer>(100);
            ArrayList<IAtom> atoms = new ArrayList<IAtom>();
            this.handleFragmentGrouping(rxn, cxstate);
            for (IAtomContainer mol : rxn.getReactants().atomContainers()) {
                for (IAtom atom : mol.atoms()) {
                    atoms.add(atom);
                    atomToMol.put(atom, mol);
                }
            }
            for (IAtomContainer mol : rxn.getAgents().atomContainers()) {
                for (IAtom atom : mol.atoms()) {
                    atoms.add(atom);
                    atomToMol.put(atom, mol);
                }
            }
            for (IAtomContainer mol : rxn.getProducts().atomContainers()) {
                for (IAtom atom : mol.atoms()) {
                    atoms.add(atom);
                    atomToMol.put(atom, mol);
                }
            }
            this.assignCxSmilesInfo(rxn.getBuilder(), rxn, atoms, atomToMol, cxstate);
        }
    }

    private void handleFragmentGrouping(IReaction rxn, CxSmilesState cxstate) {
        if (cxstate.fragGroups != null) {
            boolean reactant = true;
            int agent = 2;
            int product = 3;
            LinkedHashMap<Integer, IAtomContainer> fragMap = new LinkedHashMap<Integer, IAtomContainer>();
            HashMap<IAtomContainer, Integer> roleMap = new HashMap<IAtomContainer, Integer>();
            for (IAtomContainer mol : rxn.getReactants().atomContainers()) {
                fragMap.put(fragMap.size(), mol);
                roleMap.put(mol, 1);
            }
            for (IAtomContainer mol : rxn.getAgents().atomContainers()) {
                fragMap.put(fragMap.size(), mol);
                roleMap.put(mol, 2);
            }
            for (IAtomContainer mol : rxn.getProducts().atomContainers()) {
                fragMap.put(fragMap.size(), mol);
                roleMap.put(mol, 3);
            }
            boolean invalid = false;
            HashSet<Integer> visit = new HashSet<Integer>();
            for (List<Integer> grouping : cxstate.fragGroups) {
                IAtomContainer dest = (IAtomContainer)fragMap.get(grouping.get(0));
                if (dest == null) continue;
                if (!visit.add(grouping.get(0))) {
                    invalid = true;
                }
                for (int i = 1; i < grouping.size(); ++i) {
                    IAtomContainer src;
                    if (!visit.add(grouping.get(i))) {
                        invalid = true;
                    }
                    if ((src = (IAtomContainer)fragMap.get(grouping.get(i))) == null) continue;
                    dest.add(src);
                    roleMap.put(src, 0);
                }
            }
            if (!invalid) {
                rxn.getReactants().removeAllAtomContainers();
                rxn.getAgents().removeAllAtomContainers();
                rxn.getProducts().removeAllAtomContainers();
                for (IAtomContainer mol : fragMap.values()) {
                    switch ((Integer)roleMap.get(mol)) {
                        case 1: {
                            rxn.getReactants().addAtomContainer(mol);
                            break;
                        }
                        case 3: {
                            rxn.getProducts().addAtomContainer(mol);
                            break;
                        }
                        case 2: {
                            rxn.getAgents().addAtomContainer(mol);
                        }
                    }
                }
            }
        }
    }

    private void assignCxSmilesInfo(IChemObjectBuilder bldr, IChemObject chemObj, List<IAtom> atoms, Map<IAtom, IAtomContainer> atomToMol, CxSmilesState cxstate) {
        IAtomContainer mol;
        if (cxstate.atomLabels != null) {
            for (Map.Entry<Integer, String> e : cxstate.atomLabels.entrySet()) {
                if (e.getKey() >= atoms.size()) continue;
                IAtom old = atoms.get(e.getKey());
                IPseudoAtom pseudo = bldr.newInstance(IPseudoAtom.class, new Object[0]);
                String val = e.getValue();
                if (val.endsWith("_p")) {
                    val = val.substring(0, val.length() - 2);
                } else if (val.startsWith("_AP")) {
                    pseudo.setAttachPointNum(this.parseIntSafe(val.substring(3)));
                }
                pseudo.setLabel(val);
                pseudo.setAtomicNumber(0);
                pseudo.setImplicitHydrogenCount(0);
                mol = atomToMol.get(old);
                AtomContainerManipulator.replaceAtomByAtom(mol, old, pseudo);
                atomToMol.put(pseudo, mol);
                atoms.set(e.getKey(), pseudo);
            }
        }
        if (cxstate.atomValues != null) {
            for (Map.Entry<Integer, String> e : cxstate.atomValues.entrySet()) {
                atoms.get(e.getKey()).setProperty("cdk:Comment", e.getValue());
            }
        }
        if (cxstate.atomCoords != null) {
            int numAtoms = atoms.size();
            int numCoords = cxstate.atomCoords.size();
            int lim = Math.min(numAtoms, numCoords);
            if (cxstate.coordFlag) {
                for (int i = 0; i < lim; ++i) {
                    atoms.get(i).setPoint3d(new Point3d(cxstate.atomCoords.get(i)));
                }
            } else {
                for (int i = 0; i < lim; ++i) {
                    atoms.get(i).setPoint2d(new Point2d(cxstate.atomCoords.get(i)));
                }
            }
        }
        if (cxstate.atomRads != null) {
            for (Map.Entry<Integer, CxSmilesState.Radical> e : cxstate.atomRads.entrySet()) {
                if (e.getKey() >= atoms.size()) continue;
                int count = 0;
                switch (e.getValue()) {
                    case Monovalent: {
                        count = 1;
                        break;
                    }
                    case Divalent: 
                    case DivalentSinglet: 
                    case DivalentTriplet: {
                        count = 2;
                        break;
                    }
                    case Trivalent: 
                    case TrivalentDoublet: 
                    case TrivalentQuartet: {
                        count = 3;
                    }
                }
                IAtom atom = atoms.get(e.getKey());
                IAtomContainer mol2 = atomToMol.get(atom);
                while (count-- > 0) {
                    mol2.addSingleElectron(bldr.newInstance(ISingleElectron.class, atom));
                }
            }
        }
        HashMultimap<IAtomContainer, Sgroup> sgroupMap = HashMultimap.create();
        if (cxstate.positionVar != null) {
            for (Map.Entry<Integer, List<Integer>> e : cxstate.positionVar.entrySet()) {
                Sgroup sgroup = new Sgroup();
                sgroup.setType(SgroupType.ExtMulticenter);
                IAtom beg = atoms.get(e.getKey());
                mol = atomToMol.get(beg);
                List<IBond> bonds = mol.getConnectedBondsList(beg);
                if (bonds.isEmpty()) continue;
                sgroup.addAtom(beg);
                sgroup.addBond(bonds.get(0));
                for (Integer endpt : e.getValue()) {
                    sgroup.addAtom(atoms.get(endpt));
                }
                sgroupMap.put(mol, sgroup);
            }
        }
        if (cxstate.dataSgroups != null) {
            for (CxSmilesState.DataSgroup dsgroup : cxstate.dataSgroups) {
                if (dsgroup.field == null || !dsgroup.field.startsWith("cdk:")) continue;
                chemObj.setProperty(dsgroup.field, dsgroup.value);
            }
        }
        if (cxstate.sgroups != null) {
            block48: for (CxSmilesState.PolymerSgroup psgroup : cxstate.sgroups) {
                Sgroup sgroup = new Sgroup();
                HashSet<IAtom> atomset = new HashSet<IAtom>();
                mol = null;
                for (Integer idx : psgroup.atomset) {
                    if (idx >= atoms.size()) continue;
                    IAtom atom = atoms.get(idx);
                    IAtomContainer amol = atomToMol.get(atom);
                    if (mol == null) {
                        mol = amol;
                    } else if (amol != mol) continue block48;
                    atomset.add(atom);
                }
                if (mol == null) continue;
                for (IAtom atom : atomset) {
                    for (IBond bond : mol.getConnectedBondsList(atom)) {
                        if (atomset.contains(bond.getOther(atom))) continue;
                        sgroup.addBond(bond);
                    }
                    sgroup.addAtom(atom);
                }
                sgroup.setSubscript(psgroup.subscript);
                sgroup.putValue(SgroupKey.CtabConnectivity, psgroup.supscript);
                switch (psgroup.type) {
                    case "n": {
                        sgroup.setType(SgroupType.CtabStructureRepeatUnit);
                        break;
                    }
                    case "mon": {
                        sgroup.setType(SgroupType.CtabMonomer);
                        break;
                    }
                    case "mer": {
                        sgroup.setType(SgroupType.CtabMer);
                        break;
                    }
                    case "co": {
                        sgroup.setType(SgroupType.CtabCopolymer);
                        break;
                    }
                    case "xl": {
                        sgroup.setType(SgroupType.CtabCrossLink);
                        break;
                    }
                    case "mod": {
                        sgroup.setType(SgroupType.CtabModified);
                        break;
                    }
                    case "mix": {
                        sgroup.setType(SgroupType.CtabMixture);
                        break;
                    }
                    case "f": {
                        sgroup.setType(SgroupType.CtabFormulation);
                        break;
                    }
                    case "any": {
                        sgroup.setType(SgroupType.CtabAnyPolymer);
                        break;
                    }
                    case "gen": {
                        sgroup.setType(SgroupType.CtabGeneric);
                        break;
                    }
                    case "c": {
                        sgroup.setType(SgroupType.CtabComponent);
                        break;
                    }
                    case "grf": {
                        sgroup.setType(SgroupType.CtabGraft);
                        break;
                    }
                    case "alt": {
                        sgroup.setType(SgroupType.CtabCopolymer);
                        sgroup.putValue(SgroupKey.CtabSubType, "ALT");
                        break;
                    }
                    case "ran": {
                        sgroup.setType(SgroupType.CtabCopolymer);
                        sgroup.putValue(SgroupKey.CtabSubType, "RAN");
                        break;
                    }
                    case "blk": {
                        sgroup.setType(SgroupType.CtabCopolymer);
                        sgroup.putValue(SgroupKey.CtabSubType, "BLO");
                    }
                }
                sgroupMap.put(mol, sgroup);
            }
        }
        for (Map.Entry e : sgroupMap.asMap().entrySet()) {
            ((IAtomContainer)e.getKey()).setProperty("cdk:CtabSgroups", new ArrayList(e.getValue()));
        }
    }

    @Deprecated
    public void setPreservingAromaticity(boolean preservingAromaticity) {
        this.kekulise = !preservingAromaticity;
    }

    @Deprecated
    public boolean isPreservingAromaticity() {
        return !this.kekulise;
    }

    public void kekulise(boolean kekulise) {
        this.kekulise = kekulise;
    }
}

