/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.element;

import java.util.ArrayList;
import java.util.List;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.Nodes;
import org.xmlcml.cml.base.CMLConstants;
import org.xmlcml.cml.base.CMLElement;
import org.xmlcml.cml.base.CMLElements;
import org.xmlcml.cml.element.AbstractSymmetry;
import org.xmlcml.cml.element.CMLCrystal;
import org.xmlcml.cml.element.CMLTransform3;
import org.xmlcml.euclid.Point3;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMLSymmetry
extends AbstractSymmetry {
    public static final String NS = "cml:symmetry";

    public CMLSymmetry() {
    }

    public CMLSymmetry(CMLSymmetry old) {
        super(old);
    }

    @Override
    public Node copy() {
        return new CMLSymmetry(this);
    }

    @Override
    public CMLSymmetry makeElementInContext(Element parent) {
        return new CMLSymmetry();
    }

    public CMLSymmetry(String[] xyz) {
        this();
        for (String s : xyz) {
            CMLTransform3 t = new CMLTransform3(s);
            this.addTransform3(t);
        }
    }

    public CMLSymmetry(List<CMLTransform3> trList) {
        this();
        for (CMLTransform3 tr : trList) {
            this.addTransform3(tr);
        }
    }

    public static CMLSymmetry createFromXYZStrings(List<String> trStringList) {
        ArrayList<CMLTransform3> trList = new ArrayList<CMLTransform3>();
        for (String trString : trStringList) {
            trList.add(new CMLTransform3(trString));
        }
        return new CMLSymmetry(trList);
    }

    public CMLSymmetry convolute(CMLSymmetry sym2) {
        ArrayList<CMLTransform3> trList = new ArrayList<CMLTransform3>();
        for (CMLTransform3 tr2 : this.getTransform3Elements()) {
            for (CMLTransform3 tr3 : sym2.getTransform3Elements()) {
                CMLTransform3 trNew = tr2.concatenate(tr3);
                if (CMLTransform3.indexOf(trList, trNew, 1.0E-14) != -1) continue;
                trList.add(trNew);
            }
        }
        return new CMLSymmetry(trList);
    }

    public boolean isEqualTo(CMLSymmetry sym2, double eps) {
        boolean equals = false;
        CMLElements<CMLTransform3> thisTrs = this.getTransform3Elements();
        CMLElements<CMLTransform3> symTrs = sym2.getTransform3Elements();
        if (thisTrs.size() == symTrs.size()) {
            for (int i = 0; i < thisTrs.size(); ++i) {
                equals = false;
                for (int j = 0; j < symTrs.size(); ++j) {
                    if (!thisTrs.get(i).isEqualTo(symTrs.get(j), eps)) continue;
                    equals = true;
                    break;
                }
                if (!equals) break;
            }
        }
        return equals;
    }

    public void normalizeCrystallographically() {
        for (CMLTransform3 t : this.getTransform3Elements()) {
            t.normalizeCrystallographically();
        }
    }

    public CMLSymmetry getNonTranslations() {
        CMLSymmetry newSymmetry = new CMLSymmetry();
        CMLElements<CMLTransform3> symmetryElements = this.getTransform3Elements();
        for (CMLTransform3 tr : symmetryElements) {
            if (tr.hasNonZeroTranslationComponent() || tr.isUnit()) continue;
            newSymmetry.addTransform3(new CMLTransform3(tr));
        }
        return newSymmetry;
    }

    public List<CMLTransform3> getPureTranslations() {
        ArrayList<CMLTransform3> translations = new ArrayList<CMLTransform3>();
        CMLElements<CMLTransform3> symmetryElements = this.getTransform3Elements();
        for (CMLTransform3 tr : symmetryElements) {
            if (!tr.isPureTranslation()) continue;
            translations.add(new CMLTransform3(tr));
        }
        return translations;
    }

    public CMLCrystal.Centering getCentering() {
        return CMLSymmetry.getCentering(this.getPureTranslations());
    }

    static CMLCrystal.Centering getCentering(List<CMLTransform3> transformList) {
        CMLCrystal.Centering centering;
        block2: {
            block4: {
                block3: {
                    centering = CMLCrystal.Centering.P;
                    if (transformList.size() == 0) break block2;
                    if (transformList.size() != 1) break block3;
                    centering = transformList.get(0).isEqualTo(CMLCrystal.Centering.A.translations.get(0)) ? CMLCrystal.Centering.A : (transformList.get(0).isEqualTo(CMLCrystal.Centering.B.translations.get(0)) ? CMLCrystal.Centering.B : (transformList.get(0).isEqualTo(CMLCrystal.Centering.C.translations.get(0)) ? CMLCrystal.Centering.C : (transformList.get(0).isEqualTo(CMLCrystal.Centering.I.translations.get(0)) ? CMLCrystal.Centering.I : CMLCrystal.Centering.UNKNOWN)));
                    break block2;
                }
                if (transformList.size() != 2) break block4;
                centering = CMLCrystal.Centering.R;
                for (CMLTransform3 transform : transformList) {
                    if (transform.isEqualTo(CMLCrystal.Centering.R.translations.get(0)) || transform.isEqualTo(CMLCrystal.Centering.R.translations.get(1))) continue;
                    centering = CMLCrystal.Centering.UNKNOWN;
                    break block2;
                }
                break block2;
            }
            if (transformList.size() != 3) break block2;
            centering = CMLCrystal.Centering.F;
            for (CMLTransform3 transform : transformList) {
                if (transform.isEqualTo(CMLCrystal.Centering.F.translations.get(0)) || transform.isEqualTo(CMLCrystal.Centering.F.translations.get(1)) || transform.isEqualTo(CMLCrystal.Centering.F.translations.get(2))) continue;
                centering = CMLCrystal.Centering.UNKNOWN;
                break;
            }
        }
        return centering;
    }

    public boolean isGroup() {
        this.normalizeCrystallographically();
        CMLElements<CMLTransform3> transform3s = this.getTransform3Elements();
        int i = 0;
        boolean group = false;
        for (CMLTransform3 tr1 : transform3s) {
            int j = 0;
            for (CMLTransform3 tr2 : transform3s) {
                CMLTransform3 tr3 = tr1.concatenate(tr2);
                group = false;
                for (CMLTransform3 tr : transform3s) {
                    if (!tr.isEqualTo(tr3, 1.0E-14)) continue;
                    group = true;
                    break;
                }
                if (!group) break;
                ++j;
            }
            ++i;
        }
        return group;
    }

    public boolean isSpaceGroup() {
        CMLSymmetry symmetryCopy = new CMLSymmetry(this);
        symmetryCopy.normalizeCrystallographically();
        CMLElements<CMLTransform3> transform3s = symmetryCopy.getTransform3Elements();
        int i = 0;
        boolean group = false;
        for (CMLTransform3 tr1 : transform3s) {
            int j = 0;
            for (CMLTransform3 tr2 : transform3s) {
                CMLTransform3 tr3 = tr1.concatenate(tr2);
                tr3.normalizeCrystallographically();
                group = false;
                for (CMLTransform3 tr : transform3s) {
                    if (!tr.isEqualTo(tr3, 1.0E-14)) continue;
                    group = true;
                    break;
                }
                if (!group) break;
                ++j;
            }
            ++i;
        }
        return group;
    }

    public int getPointGroupMultiplicity(Point3 point, double eps) {
        int operatorCount = 0;
        CMLElements<CMLTransform3> transforms = this.getTransform3Elements();
        for (CMLTransform3 tr : transforms) {
            Point3 newPoint = tr.transform(point);
            if (!newPoint.isEqualTo(point, eps)) continue;
            ++operatorCount;
        }
        return operatorCount;
    }

    public int getSpaceGroupMultiplicity(Point3 point) {
        int operatorCount = 0;
        if (point != null) {
            CMLElements<CMLTransform3> transforms = this.getTransform3Elements();
            for (CMLTransform3 tr : transforms) {
                Point3 newPoint = tr.transform(point);
                if (!newPoint.equalsCrystallographically(point)) continue;
                ++operatorCount;
            }
        }
        return operatorCount;
    }

    public static CMLSymmetry getContainedSymmetry(CMLElement element) throws RuntimeException {
        Nodes symmetryNodes = element.query(".//cml:symmetry", CMLConstants.CML_XPATH);
        if (symmetryNodes.size() == 0) {
            throw new RuntimeException("NO <symmetry> FOUND");
        }
        if (symmetryNodes.size() > 1) {
            throw new RuntimeException("TOO MANY <symmetry> FOUND " + symmetryNodes.size());
        }
        return (CMLSymmetry)symmetryNodes.get(0);
    }
}

