% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimize-files.R
\name{optimize_files}
\alias{optimize_files}
\title{Optimize `.R` files.}
\usage{
optimize_files(
  files,
  optimizers = all_optimizers,
  overwrite = FALSE,
  iterations = Inf
)
}
\arguments{
\item{files}{A character vector with paths to files to optimize.}

\item{optimizers}{A named list of optimizer functions.}

\item{overwrite}{A logical indicating if files should be overwritten, or
saved into new files with "optimized_" prefix.}

\item{iterations}{Numeric indicating the number of times optimizers should
pass. If there was no change after current pass, it will stop.}
}
\description{
Performs the desired optimization strategies in the files specified.
Carefully examine the results after running this function!
If several files interact between them (functions from one file use
functions from the other), then optimizing all of them together gives more
information to rco.
}
