% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oneSampleDominance.r
\name{oneSampleDominance}
\alias{oneSampleDominance}
\title{Dominance statistic for one-sample data}
\usage{
oneSampleDominance(
  x,
  mu = 0,
  ci = FALSE,
  conf = 0.95,
  type = "perc",
  R = 1000,
  histogram = FALSE,
  digits = 3,
  na.rm = TRUE,
  ...
)
}
\arguments{
\item{x}{A vector of numeric values.}

\item{mu}{The median against which to compare the values.}

\item{ci}{If \code{TRUE}, returns confidence intervals by bootstrap.
May be slow.}

\item{conf}{The level for the confidence interval.}

\item{type}{The type of confidence interval to use.
Can be any of "\code{norm}", "\code{basic}", 
              "\code{perc}", or "\code{bca}".
Passed to \code{boot.ci}.}

\item{R}{The number of replications to use for bootstrap.}

\item{histogram}{If \code{TRUE}, produces a histogram of bootstrapped values.}

\item{digits}{The number of significant digits in the output.}

\item{na.rm}{If \code{TRUE}, removes \code{NA} values from
the input vector \code{x}.}

\item{...}{Additional arguments.}
}
\value{
A small data frame consisting of descriptive statistics,
        the dominance statistic,
        and potentially the lower and upper confidence limits.
}
\description{
Calculates a dominance 
             effect size statistic
             compared with a theoretical median
             for one-sample data
             with confidence intervals by bootstrap
}
\details{
The calculated \code{Dominance} statistic is simply 
         the proportion of observations greater than \code{mu} minus the
         the proportion of observations less than \code{mu}.
         
         It will range from -1 to 1, with 0 indicating that the median is
         equal to \code{mu}, 
         and 1 indicating that the observations are all greater in value
         than \code{mu},
         and -1 indicating that the observations are all less in value
         than \code{mu}.
         
         This statistic is appropriate for truly ordinal data,
         and could be considered an effect size statistic for
         a one-sample sign test. 
         
         Ordered category data need to re-coded as
         numeric, e.g. as with \code{as.numeric(Ordinal.variable)}.

          When the statistic is close to 1 or close to -1,
          or with small sample size,
          the confidence intervals 
          determined by this
          method may not be reliable, or the procedure may fail.
          
          VDA is the analogous statistic, converted to a probability,
          ranging from 0 to 1, specifically,
          \code{VDA = Dominance / 2 + 0.5}.
}
\examples{
data(Catbus)
library(DescTools)
SignTest(Catbus$Rating, mu=5.5)
oneSampleDominance(Catbus$Rating, mu=5.5)

}
\references{
\url{https://rcompanion.org/handbook/F_03.html}
}
\seealso{
\code{\link{cliffDelta}}
}
\author{
Salvatore Mangiafico, \email{mangiafico@njaes.rutgers.edu}
}
\concept{effect size}
