% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_lidar.R
\name{generate_lidar}
\alias{generate_lidar}
\title{Generate lidar parameters}
\usage{
generate_lidar(
  mean_beam_pc = 10,
  sd_beam_pc = 5,
  klaser_pc = 0.63,
  transmittance_laser = 0.4,
  iter_pointcloud_generation = NULL
)
}
\arguments{
\item{mean_beam_pc}{num. Mean pulse density (pulses per m2).}

\item{sd_beam_pc}{num. Standard deviation of pulse density (per m2).}

\item{klaser_pc}{num. laser attenuation factor.}

\item{transmittance_laser}{num. Percentage of pulses that continue through
the canopy after a hit.}

\item{iter_pointcloud_generation}{num. Number of iteration for point cloud
generation.}
}
\value{
A data frame of lidar simulation parameters.
}
\description{
Function to generate the lidar parameters used in TROLL lidar
  simulation. All parameters have a default value from literature.
}
\examples{
generate_lidar(iter_pointcloud_generation = 3600)
}
