% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_stack.R
\name{load_stack}
\alias{load_stack}
\title{Load outputs from a stack of simulations}
\usage{
load_stack(name, path, thin = NULL)
}
\arguments{
\item{name}{char. Name given to the stack output.}

\item{path}{char. Path where the stack is saved.}

\item{thin}{int. Vector of integers corresponding to the iterations to be
kept to reduce output size, default is NULL and corresponds to no thinning.}
}
\value{
An S4 \code{\link[=trollstack]{trollstack()}} class object.
}
\description{
\code{load_stack} load outputs from a stack of \code{TROLL} simulation files using
\code{TROLL} stack of simulation \code{name} and \code{path}.
}
\examples{
\dontrun{
load_stack("test", "./")
}

}
\seealso{
\code{\link[=trollsim]{trollsim()}}, \code{\link[=trollstack]{trollstack()}}, \code{\link[=load_sim]{load_sim()}}, \code{\link[=load_stack]{load_stack()}}
}
